/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

public class KafkaStreamsBinderMetrics {
    private final MeterRegistry meterRegistry;
    private MeterBinder meterBinder;

    public KafkaStreamsBinderMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void bindTo(final Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans, final MeterRegistry meterRegistry) {
        if (this.meterBinder == null) {
            this.meterBinder = new MeterBinder(){

                public void bindTo(MeterRegistry registry) {
                    if (streamsBuilderFactoryBeans != null) {
                        for (StreamsBuilderFactoryBean streamsBuilderFactoryBean : streamsBuilderFactoryBeans) {
                            KafkaStreams kafkaStreams = streamsBuilderFactoryBean.getKafkaStreams();
                            Map metrics = kafkaStreams.metrics();
                            HashSet<String> meterNames = new HashSet<String>();
                            for (Map.Entry metric : metrics.entrySet()) {
                                String sanitized = KafkaStreamsBinderMetrics.sanitize(((MetricName)metric.getKey()).group() + "." + ((MetricName)metric.getKey()).name());
                                String applicationId = streamsBuilderFactoryBean.getStreamsConfiguration().getProperty("application.id");
                                String name = streamsBuilderFactoryBeans.size() > 1 ? applicationId + "." + sanitized : sanitized;
                                Gauge.Builder builder = Gauge.builder((String)name, (Object)this, (ToDoubleFunction)this.toDoubleFunction((Metric)metric.getValue()));
                                Map tags = ((MetricName)metric.getKey()).tags();
                                for (Map.Entry tag : tags.entrySet()) {
                                    builder.tag((String)tag.getKey(), (String)tag.getValue());
                                }
                                if (meterNames.contains(name)) continue;
                                builder.description(((MetricName)metric.getKey()).description()).register(meterRegistry);
                                meterNames.add(name);
                            }
                        }
                    }
                }

                ToDoubleFunction toDoubleFunction(Metric metric) {
                    return o -> {
                        if (metric.metricValue() instanceof Number) {
                            return (Double)metric.metricValue();
                        }
                        return 0.0;
                    };
                }
            };
        }
        this.meterBinder.bindTo(this.meterRegistry);
    }

    private static String sanitize(String value) {
        return value.replaceAll("-", ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetrics(Set<StreamsBuilderFactoryBean> streamsBuilderFactoryBeans) {
        KafkaStreamsBinderMetrics kafkaStreamsBinderMetrics = this;
        synchronized (kafkaStreamsBinderMetrics) {
            this.bindTo(streamsBuilderFactoryBeans, this.meterRegistry);
        }
    }
}

