/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsRegistry;

public class QueryableStoreRegistry {
    private final KafkaStreamsRegistry kafkaStreamsRegistry;

    public QueryableStoreRegistry(KafkaStreamsRegistry kafkaStreamsRegistry) {
        this.kafkaStreamsRegistry = kafkaStreamsRegistry;
    }

    public <T> T getQueryableStoreType(String storeName, QueryableStoreType<T> storeType) {
        for (KafkaStreams kafkaStream : this.kafkaStreamsRegistry.getKafkaStreams()) {
            try {
                Object store = kafkaStream.store(storeName, storeType);
                if (store == null) continue;
                return (T)store;
            }
            catch (InvalidStateStoreException invalidStateStoreException) {
            }
        }
        return null;
    }
}

