/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.streams.KStreamBinder;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsDlqDispatch;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsMessageConversionDelegate;
import org.springframework.cloud.stream.binder.kafka.streams.KeyValueSerdeResolver;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsExtendedBindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={KafkaAutoConfiguration.class, KafkaStreamsBinderHealthIndicatorConfiguration.class})
public class KStreamBinderConfiguration {
    @Bean
    public KafkaTopicProvisioner provisioningProvider(KafkaStreamsBinderConfigurationProperties kafkaStreamsBinderConfigurationProperties, KafkaProperties kafkaProperties) {
        return new KafkaTopicProvisioner((KafkaBinderConfigurationProperties)kafkaStreamsBinderConfigurationProperties, kafkaProperties);
    }

    @Bean
    public KStreamBinder kStreamBinder(KafkaStreamsBinderConfigurationProperties binderConfigurationProperties, KafkaTopicProvisioner kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate KafkaStreamsMessageConversionDelegate2, KafkaStreamsBindingInformationCatalogue KafkaStreamsBindingInformationCatalogue2, KeyValueSerdeResolver keyValueSerdeResolver, KafkaStreamsExtendedBindingProperties kafkaStreamsExtendedBindingProperties, @Qualifier(value="kafkaStreamsDlqDispatchers") Map<String, KafkaStreamsDlqDispatch> kafkaStreamsDlqDispatchers) {
        KStreamBinder kStreamBinder = new KStreamBinder(binderConfigurationProperties, kafkaTopicProvisioner, KafkaStreamsMessageConversionDelegate2, KafkaStreamsBindingInformationCatalogue2, keyValueSerdeResolver, kafkaStreamsDlqDispatchers);
        kStreamBinder.setKafkaStreamsExtendedBindingProperties(kafkaStreamsExtendedBindingProperties);
        return kStreamBinder;
    }

    @Bean
    @ConditionalOnBean(name={"outerContext"})
    public static BeanFactoryPostProcessor outerContextBeanFactoryPostProcessor() {
        return beanFactory -> {
            ApplicationContext outerContext = (ApplicationContext)beanFactory.getBean("outerContext");
            beanFactory.registerSingleton(KafkaStreamsBinderConfigurationProperties.class.getSimpleName(), outerContext.getBean(KafkaStreamsBinderConfigurationProperties.class));
            beanFactory.registerSingleton(KafkaStreamsMessageConversionDelegate.class.getSimpleName(), outerContext.getBean(KafkaStreamsMessageConversionDelegate.class));
            beanFactory.registerSingleton(KafkaStreamsBindingInformationCatalogue.class.getSimpleName(), outerContext.getBean(KafkaStreamsBindingInformationCatalogue.class));
            beanFactory.registerSingleton(KeyValueSerdeResolver.class.getSimpleName(), outerContext.getBean(KeyValueSerdeResolver.class));
            beanFactory.registerSingleton(KafkaStreamsExtendedBindingProperties.class.getSimpleName(), outerContext.getBean(KafkaStreamsExtendedBindingProperties.class));
        };
    }
}

