/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.infrastructure.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.infrastructure.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.infrastructure.item.database.JdbcBatchItemWriter;
import org.springframework.batch.infrastructure.item.database.builder.JdbcBatchItemWriterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.cloud.task.batch.autoconfigure.jdbc.JDBCSingleStepDataSourceAutoConfiguration;
import org.springframework.cloud.task.batch.autoconfigure.jdbc.JdbcBatchItemWriterProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@EnableConfigurationProperties(value={JdbcBatchItemWriterProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
@Import(value={JDBCSingleStepDataSourceAutoConfiguration.class})
public class JdbcBatchItemWriterAutoConfiguration {
    private static final Log logger = LogFactory.getLog(JdbcBatchItemWriterAutoConfiguration.class);
    @Autowired(required=false)
    private ItemPreparedStatementSetter itemPreparedStatementSetter;
    @Autowired(required=false)
    private ItemSqlParameterSourceProvider itemSqlParameterSourceProvider;
    @Autowired
    ApplicationContext applicationContext;
    private JdbcBatchItemWriterProperties properties;
    private DataSource dataSource;

    public JdbcBatchItemWriterAutoConfiguration(DataSource dataSource, JdbcBatchItemWriterProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.jdbcbatchitemwriter", name={"name"})
    public JdbcBatchItemWriter<Map<String, Object>> itemWriter() {
        DataSource writerDataSource = this.dataSource;
        try {
            writerDataSource = (DataSource)this.applicationContext.getBean("jdbcBatchItemWriterSpringDataSource", DataSource.class);
        }
        catch (Exception ex) {
            logger.info((Object)"Using Default Data Source for the JdbcBatchItemWriter");
        }
        JdbcBatchItemWriterBuilder jdbcBatchItemWriterBuilder = new JdbcBatchItemWriterBuilder().dataSource(writerDataSource).sql(this.properties.getSql());
        if (this.itemPreparedStatementSetter != null) {
            jdbcBatchItemWriterBuilder.itemPreparedStatementSetter(this.itemPreparedStatementSetter);
        } else if (this.itemSqlParameterSourceProvider != null) {
            jdbcBatchItemWriterBuilder.itemSqlParameterSourceProvider(this.itemSqlParameterSourceProvider);
        } else {
            jdbcBatchItemWriterBuilder.columnMapped();
        }
        jdbcBatchItemWriterBuilder.assertUpdates(this.properties.isAssertUpdates());
        return jdbcBatchItemWriterBuilder.build();
    }

    @ConditionalOnProperty(prefix="spring.batch.job.jdbcbatchitemwriter.datasource", name={"enable"}, havingValue="true")
    @Bean(name={"jdbcBatchItemWriterDataSourceProperties"})
    @ConfigurationProperties(value="jdbcbatchitemwriter.datasource")
    public DataSourceProperties jdbcBatchItemWriterDataSourceProperties() {
        return new DataSourceProperties();
    }

    @ConditionalOnProperty(prefix="spring.batch.job.jdbcbatchitemwriter.datasource", name={"enable"}, havingValue="true")
    @Bean(name={"jdbcBatchItemWriterSpringDataSource"})
    public DataSource writerDataSource(@Qualifier(value="jdbcBatchItemWriterDataSourceProperties") DataSourceProperties writerDataSourceProperties) {
        DataSource result = writerDataSourceProperties.initializeDataSourceBuilder().build();
        return result;
    }
}

