/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.batch.item.database.builder.JdbcCursorItemReaderBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.jdbc.JdbcCursorItemReaderProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={JdbcCursorItemReaderProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.batch.job.jdbccursoritemreader", name={"name"})
public class JdbcCursorItemReaderAutoConfiguration {
    private final JdbcCursorItemReaderProperties properties;
    private final DataSource dataSource;

    public JdbcCursorItemReaderAutoConfiguration(JdbcCursorItemReaderProperties properties, DataSource dataSource) {
        this.properties = properties;
        this.dataSource = dataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public JdbcCursorItemReader<Map<String, Object>> itemReader(@Autowired(required=false) RowMapper<Map<String, Object>> rowMapper, @Autowired(required=false) PreparedStatementSetter preparedStatementSetter) {
        return new JdbcCursorItemReaderBuilder().name(this.properties.getName()).currentItemCount(this.properties.getCurrentItemCount()).dataSource(this.dataSource).driverSupportsAbsolute(this.properties.isDriverSupportsAbsolute()).fetchSize(this.properties.getFetchSize()).ignoreWarnings(this.properties.isIgnoreWarnings()).maxItemCount(this.properties.getMaxItemCount()).maxRows(this.properties.getMaxRows()).queryTimeout(this.properties.getQueryTimeout()).saveState(this.properties.isSaveState()).sql(this.properties.getSql()).rowMapper(rowMapper).preparedStatementSetter(preparedStatementSetter).verifyCursorPosition(this.properties.isVerifyCursorPosition()).useSharedExtendedConnection(this.properties.isUseSharedExtendedConnection()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public RowMapper<Map<String, Object>> rowMapper() {
        return new MapRowMapper();
    }

    public static class MapRowMapper
    implements RowMapper<Map<String, Object>> {
        public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
            HashMap<String, Object> item = new HashMap<String, Object>(rs.getMetaData().getColumnCount());
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                item.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
            }
            return item;
        }
    }
}

