/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.autoconfigure.flatfile;

import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineCallbackHandler;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.builder.FlatFileItemReaderBuilder;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.task.batch.autoconfigure.flatfile.FlatFileItemReaderProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FlatFileItemReaderProperties.class})
@AutoConfigureAfter(value={BatchAutoConfiguration.class})
public class FlatFileItemReaderAutoConfiguration {
    private final FlatFileItemReaderProperties properties;

    public FlatFileItemReaderAutoConfiguration(FlatFileItemReaderProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job.flatfileitemreader", name={"name"})
    public FlatFileItemReader<Map<String, Object>> itemReader(@Autowired(required=false) LineTokenizer lineTokenizer, @Autowired(required=false) FieldSetMapper<Map<String, Object>> fieldSetMapper, @Autowired(required=false) LineMapper<Map<String, Object>> lineMapper, @Autowired(required=false) LineCallbackHandler skippedLinesCallback, @Autowired(required=false) RecordSeparatorPolicy recordSeparatorPolicy) {
        FlatFileItemReaderBuilder mapFlatFileItemReaderBuilder = new FlatFileItemReaderBuilder().name(this.properties.getName()).resource(this.properties.getResource()).saveState(this.properties.isSaveState()).maxItemCount(this.properties.getMaxItemCount()).currentItemCount(this.properties.getCurrentItemCount()).strict(this.properties.isStrict()).encoding(this.properties.getEncoding()).linesToSkip(this.properties.getLinesToSkip()).comments(this.properties.getComments().toArray(new String[this.properties.getComments().size()]));
        mapFlatFileItemReaderBuilder.lineTokenizer(lineTokenizer);
        if (recordSeparatorPolicy != null) {
            mapFlatFileItemReaderBuilder.recordSeparatorPolicy(recordSeparatorPolicy);
        }
        mapFlatFileItemReaderBuilder.fieldSetMapper(fieldSetMapper);
        mapFlatFileItemReaderBuilder.lineMapper(lineMapper);
        mapFlatFileItemReaderBuilder.skippedLinesCallback(skippedLinesCallback);
        if (this.properties.isDelimited()) {
            mapFlatFileItemReaderBuilder.delimited().quoteCharacter(this.properties.getQuoteCharacter()).delimiter(this.properties.getDelimiter()).includedFields(this.properties.getIncludedFields().toArray(new Integer[0])).names(this.properties.getNames()).beanMapperStrict(this.properties.isParsingStrict()).fieldSetMapper((FieldSetMapper)new MapFieldSetMapper());
        } else if (this.properties.isFixedLength()) {
            mapFlatFileItemReaderBuilder.fixedLength().columns(this.properties.getRanges().toArray(new Range[0])).names(this.properties.getNames()).fieldSetMapper((FieldSetMapper)new MapFieldSetMapper()).beanMapperStrict(this.properties.isParsingStrict());
        }
        return mapFlatFileItemReaderBuilder.build();
    }

    public static class MapFieldSetMapper
    implements FieldSetMapper<Map<String, Object>> {
        public Map<String, Object> mapFieldSet(FieldSet fieldSet) {
            return new HashMap<Object, Object>(fieldSet.getProperties());
        }
    }
}

