/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinUrlExtractor;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ZipkinRestTemplateWrapper
extends RestTemplate {
    private static final Log log = LogFactory.getLog(ZipkinRestTemplateWrapper.class);
    private static final int DEFAULT_TIMEOUT = 500;
    private final ZipkinProperties zipkinProperties;
    private final ZipkinUrlExtractor extractor;

    public ZipkinRestTemplateWrapper(ZipkinProperties zipkinProperties, ZipkinUrlExtractor extractor) {
        this.zipkinProperties = zipkinProperties;
        this.extractor = extractor;
        this.setRequestFactory(this.clientHttpRequestFactory());
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(500);
        factory.setConnectTimeout(500);
        return factory;
    }

    protected <T> T doExecute(URI originalUrl, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        URI uri = this.extractor.zipkinUrl(this.zipkinProperties);
        URI newUri = this.resolvedZipkinUri(originalUrl, uri);
        return (T)super.doExecute(newUri, method, requestCallback, responseExtractor);
    }

    private URI resolvedZipkinUri(URI originalUrl, URI resolvedZipkinUri) {
        try {
            return new URI(resolvedZipkinUri.getScheme(), resolvedZipkinUri.getUserInfo(), resolvedZipkinUri.getHost(), resolvedZipkinUri.getPort(), originalUrl.getPath(), originalUrl.getQuery(), originalUrl.getFragment());
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to create the new URI from original [" + originalUrl + "] and new one [" + resolvedZipkinUri + "]"));
            }
            return originalUrl;
        }
    }
}

