/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.test;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;

public interface TestSpanHandler
extends Iterable<FinishedSpan> {
    public List<FinishedSpan> reportedSpans();

    public FinishedSpan takeLocalSpan();

    public void clear();

    public FinishedSpan takeRemoteSpan(Span.Kind var1);

    public FinishedSpan takeRemoteSpanWithError(Span.Kind var1);

    public FinishedSpan get(int var1);

    default public void assertAllSpansWereFinishedOrAbandoned(Queue<Span> createdSpans) {
        List<FinishedSpan> finishedSpans = this.reportedSpans();
        ((ListAssert)BDDAssertions.then(finishedSpans).as("There should be that many finished spans as many created ones", new Object[0])).hasSize(createdSpans.size());
        List matchedFinishedSpans = finishedSpans.stream().filter(f -> createdSpans.stream().anyMatch(cs -> f.getSpanId().equals(cs.context().spanId()))).collect(Collectors.toList());
        List matchedCreatedSpans = createdSpans.stream().filter(cs -> finishedSpans.stream().anyMatch(f -> cs.context().spanId().equals(f.getSpanId()))).collect(Collectors.toList());
        List missingFinishedSpans = finishedSpans.stream().filter(f -> matchedFinishedSpans.stream().noneMatch(m -> m.getSpanId().equals(f.getSpanId()))).collect(Collectors.toList());
        List missingCreatedSpans = createdSpans.stream().filter(f -> matchedCreatedSpans.stream().noneMatch(m -> m.context().spanId().equals(f.context().spanId()))).collect(Collectors.toList());
        if (!missingFinishedSpans.isEmpty() || !missingCreatedSpans.isEmpty()) {
            throw new AssertionError((Object)("There were unmatched created spans " + missingCreatedSpans + " and/or finished span " + missingFinishedSpans));
        }
    }
}

