/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.integration.parser;

import feign.Request;
import feign.Response;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpResponseParser;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"spring.sleuth.web.servlet.enabled=false", "spring.application.name=fooservice", "spring.sleuth.web.client.skip-pattern=/skip.*"})
@DirtiesContext
public abstract class WebClientCustomParserTests {
    @Autowired
    TestFeignInterface testFeignInterface;
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @LocalServerPort
    int port;
    @Autowired
    FooController fooController;

    @AfterEach
    @BeforeEach
    public void close() {
        this.spans.clear();
        this.fooController.clear();
    }

    @Test
    public void should_set_tags_via_server_and_client_parsers() {
        this.testFeignInterface.getTraceId();
        Map<String, String> clientSideTags = this.spans.reportedSpans().stream().filter(f -> f.getKind().equals((Object)Span.Kind.CLIENT)).flatMap(f -> f.getTags().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ((MapAssert)((MapAssert)((MapAssert)BDDAssertions.then(clientSideTags).containsEntry((Object)"ClientRequest", (Object)"Tag")).containsEntry((Object)"ClientRequestFeign", (Object)"GET")).containsEntry((Object)"ClientResponse", (Object)"Tag")).containsEntry((Object)"ClientResponseFeign", (Object)"200");
    }

    @Configuration(proxyBeanMethods=false)
    public static class ClientParserConfiguration {
        @Bean(name={"sleuthHttpClientRequestParser"})
        HttpRequestParser myHttpClientRequestParser() {
            return (request, context, span) -> {
                span.name(request.method());
                span.tag("ClientRequest", "Tag");
                Object unwrap = request.unwrap();
                if (unwrap instanceof Request) {
                    Request req = (Request)unwrap;
                    span.tag("ClientRequestFeign", req.httpMethod().name());
                }
            };
        }

        @Bean(name={"sleuthHttpClientResponseParser"})
        HttpResponseParser myHttpClientResponseParser() {
            return (response, context, span) -> {
                span.tag("ClientResponse", "Tag");
                Object unwrap = response.unwrap();
                if (unwrap instanceof Response) {
                    Response resp = (Response)unwrap;
                    span.tag("ClientResponseFeign", String.valueOf(resp.status()));
                }
            };
        }
    }

    @RestController
    public static class FooController {
        Span span;

        @RequestMapping(value={"/traceid"}, method={RequestMethod.GET})
        public String traceId(@RequestHeader(value="b3") String b3Single) {
            BDDAssertions.then((String)b3Single).isNotEmpty();
            return b3Single;
        }

        public Span getSpan() {
            return this.span;
        }

        public void clear() {
            this.span = null;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class SimpleLoadBalancerClientConfiguration {
        @Value(value="${local.server.port}")
        private int port = 0;

        @Bean
        public ServiceInstanceListSupplier serviceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)"fooservice", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("fooservice-1", "fooservice", "localhost", this.port, false)});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration(exclude={JmxAutoConfiguration.class})
    @EnableFeignClients
    @LoadBalancerClient(value="fooservice", configuration={SimpleLoadBalancerClientConfiguration.class})
    @Import(value={ClientParserConfiguration.class})
    public static class TestConfiguration {
        @Bean
        FooController fooController() {
            return new FooController();
        }
    }

    @FeignClient(value="fooservice")
    public static interface TestFeignInterface {
        @RequestMapping(method={RequestMethod.GET}, value={"/traceid"})
        public ResponseEntity<String> getTraceId();
    }
}

