/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"management.endpoints.web.exposure.include:*", "server.servlet.context-path:/context-path"})
public abstract class SkipEndPointsIntegrationTestsWithContextPathWithBasePath {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @LocalServerPort
    int port;

    @BeforeEach
    @AfterEach
    public void clearSpans() {
        this.spans.clear();
    }

    @Test
    public void should_not_sample_skipped_endpoint_with_context_path() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/context-path/actuator/health", String.class, new Object[0]);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(0);
    }

    @Test
    public void should_sample_non_actuator_endpoint_with_context_path() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/context-path/something", String.class, new Object[0]);
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    @RestController
    public static class TestConfig {
        @GetMapping(value={"something"})
        void doNothing() {
        }
    }
}

