/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.presentation.StandardRepresentation;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class FlowsScopePassingSpanSubscriberTests {
    static final String HOOK_KEY = "org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration.TraceReactorConfiguration";
    static final String LIFTER_NAME = "org.springframework.cloud.sleuth.instrument.reactor.ReactorHooksHelper.ScopePassingLifter";
    AnnotationConfigApplicationContext springContext = new AnnotationConfigApplicationContext();

    protected abstract CurrentTraceContext currentTraceContext();

    protected abstract TraceContext context();

    @BeforeEach
    public void setup() {
        Hooks.resetOnEachOperator();
        Hooks.resetOnLastOperator();
        Schedulers.resetOnScheduleHooks();
    }

    @AfterEach
    public void close() {
        this.springContext.close();
        Hooks.resetOnEachOperator();
        Hooks.resetOnLastOperator();
        Schedulers.resetOnScheduleHooks();
    }

    @Test
    public void should_not_trace_scalar_flows() {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Function transformer = ReactorSleuth.onEachOperatorForOnEachInstrumentation((ConfigurableApplicationContext)this.springContext);
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            CoreSubscriber<Object> assertNoSpanSubscriber = new CoreSubscriber<Object>(){

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                    Assertions.assertThat((Object)s).isNotInstanceOf(ScopePassingSpanSubscriber.class);
                }

                public void onNext(Object o) {
                }

                public void onError(Throwable t) {
                }

                public void onComplete() {
                }
            };
            CoreSubscriber<Object> assertSpanSubscriber = new CoreSubscriber<Object>(){

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                    Assertions.assertThat((Object)s).isInstanceOf(ScopePassingSpanSubscriber.class);
                }

                public void onNext(Object o) {
                }

                public void onError(Throwable t) {
                }

                public void onComplete() {
                }
            };
            ((Publisher)transformer.apply(Mono.just((Object)1).hide())).subscribe((Subscriber)assertSpanSubscriber);
            ((Publisher)transformer.apply(Mono.just((Object)1))).subscribe((Subscriber)assertNoSpanSubscriber);
            ((Publisher)transformer.apply(Mono.error((Throwable)new Exception()).hide())).subscribe((Subscriber)assertSpanSubscriber);
            ((Publisher)transformer.apply(Mono.error((Throwable)new Exception()))).subscribe((Subscriber)assertNoSpanSubscriber);
            ((Publisher)transformer.apply(Mono.empty().hide())).subscribe((Subscriber)assertSpanSubscriber);
            ((Publisher)transformer.apply(Mono.empty())).subscribe((Subscriber)assertNoSpanSubscriber);
        }
        Awaitility.await().untilAsserted(() -> BDDAssertions.then((Object)this.currentTraceContext().context()).isNull());
    }

    @ParameterizedTest
    @MethodSource(value={"should_not_double_wrap_async_publisher_Args"})
    public void should_not_double_wrap_async_publisher(String name, Supplier<Mono<Integer>> sourceSupplier) {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.registerBean(Tracer.class, () -> (Tracer)Mockito.mock(Tracer.class), new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Hooks.onEachOperator((String)HOOK_KEY, (Function)ReactorSleuth.onEachOperatorForOnEachInstrumentation((ConfigurableApplicationContext)this.springContext));
        Hooks.onLastOperator((String)HOOK_KEY, (Function)ReactorSleuth.onLastOperatorForOnEachInstrumentation((ConfigurableApplicationContext)this.springContext));
        AtomicBoolean once = new AtomicBoolean();
        Hooks.onLastOperator((String)"test", p -> {
            if (once.compareAndSet(false, true)) {
                Assertions.assertThat((Object)Scannable.from((Object)p).scanUnsafe(Scannable.Attr.LIFTER)).isEqualTo((Object)LIFTER_NAME);
                Object parent = Scannable.from((Object)p).scanUnsafe(Scannable.Attr.PARENT);
                Assertions.assertThat((Object)Scannable.from((Object)parent).scanUnsafe(Scannable.Attr.LIFTER)).isNotEqualTo((Object)LIFTER_NAME);
            }
            return p;
        });
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            Mono<Integer> source = sourceSupplier.get();
            source.subscribe((Subscriber)new CoreSubscriber<Integer>(){

                public void onSubscribe(Subscription subscription) {
                    Assertions.assertThat((Object)subscription).isInstanceOf(ScopePassingSpanSubscriber.class);
                    ScopePassingSpanSubscriber spanSubscriber = (ScopePassingSpanSubscriber)subscription;
                    Object parent = spanSubscriber.scanUnsafe(Scannable.Attr.PARENT);
                    ((ObjectAssert)Assertions.assertThat((Object)parent).isInstanceOf(Subscriber.class)).isNotInstanceOf(ScopePassingSpanSubscriber.class);
                }

                public void onNext(Integer integer) {
                }

                public void onError(Throwable throwable) {
                    throw Exceptions.propagate((Throwable)throwable);
                }

                public void onComplete() {
                }
            });
        }
    }

    private static Stream<Arguments> should_not_double_wrap_async_publisher_Args() {
        return Stream.of(Arguments.of((Object[])new Object[]{"hidden by defer", () -> Mono.defer(() -> Mono.fromSupplier(() -> 1).hide().subscribeOn(Schedulers.parallel()))}), Arguments.of((Object[])new Object[]{"directly accessible", () -> Mono.fromSupplier(() -> 1).hide().subscribeOn(Schedulers.parallel())}));
    }

    static {
        StandardRepresentation.registerFormatterForType(ScopePassingSpanSubscriber.class, Objects::toString);
    }
}

