/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.cloud.sleuth.test.TestTracer;
import org.springframework.cloud.sleuth.test.TestTracingBeanPostProcessor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import reactor.core.publisher.Flux;

public abstract class TraceFunctionAroundWrapperTests {
    @Test
    public void test_tracing_with_supplier() {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{this.configuration(), SampleConfiguration.class}).run(new String[]{"--logging.level.org.springframework.cloud.function=DEBUG", "--spring.main.lazy-initialization=true"});){
            TestSpanHandler spanHandler = (TestSpanHandler)context.getBean(TestSpanHandler.class);
            Assertions.assertThat(spanHandler.reportedSpans()).isEmpty();
            FunctionCatalog catalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
            SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)catalog.lookup("greeter");
            Message result = (Message)function.get();
            Assertions.assertThat((String)((String)result.getPayload())).isEqualTo("hello");
            Assertions.assertThat((int)spanHandler.reportedSpans().size()).isEqualTo(2);
            Assertions.assertThat((String)((String)result.getHeaders().get((Object)"b3"))).contains(new CharSequence[]{spanHandler.get(0).getTraceId()});
            spanHandler.assertAllSpansWereFinishedOrAbandoned(((TestTracer)context.getBean(TestTracer.class)).createdSpans());
        }
    }

    @Test
    public void test_tracing_with_reactive_supplier() {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{this.configuration(), SampleConfiguration.class}).run(new String[]{"--logging.level.org.springframework.cloud.function=DEBUG", "--spring.main.lazy-initialization=true"});){
            TestSpanHandler spanHandler = (TestSpanHandler)context.getBean(TestSpanHandler.class);
            Assertions.assertThat(spanHandler.reportedSpans()).isEmpty();
            FunctionCatalog catalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
            SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)catalog.lookup("reactiveGreeter");
            function.setSkipOutputConversion(true);
            Object result = function.get();
            Assertions.assertThat((Object)result).isInstanceOf(Publisher.class);
        }
    }

    @Test
    public void test_tracing_with_function() {
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{this.configuration(), SampleConfiguration.class}).run(new String[]{"--logging.level.org.springframework.cloud.function=DEBUG", "--spring.main.lazy-initialization=true"});){
            TestSpanHandler spanHandler = (TestSpanHandler)context.getBean(TestSpanHandler.class);
            Assertions.assertThat(spanHandler.reportedSpans()).isEmpty();
            FunctionCatalog catalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
            SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)catalog.lookup("uppercase");
            Message result = (Message)function.apply((Object)MessageBuilder.withPayload((Object)"hello").build());
            Assertions.assertThat((Object)result.getPayload()).isEqualTo((Object)"HELLO");
            Assertions.assertThat((int)spanHandler.reportedSpans().size()).isEqualTo(3);
            Assertions.assertThat((String)((String)result.getHeaders().get((Object)"b3"))).contains(new CharSequence[]{spanHandler.get(0).getTraceId()});
            spanHandler.assertAllSpansWereFinishedOrAbandoned(((TestTracer)context.getBean(TestTracer.class)).createdSpans());
        }
    }

    protected abstract Class<?> configuration();

    @EnableAutoConfiguration
    public static class SampleConfiguration {
        @Bean
        public Supplier<String> greeter() {
            return () -> "hello";
        }

        @Bean
        public Supplier<Flux<String>> reactiveGreeter() {
            return () -> Flux.just((Object)"hello");
        }

        @Bean
        public Function<String, String> uppercase() {
            return v -> v.toUpperCase();
        }

        @Bean
        static TestTracingBeanPostProcessor testTracerBeanPostProcessor() {
            return new TestTracingBeanPostProcessor();
        }
    }
}

