/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor.sample;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.sample.RequestSender;
import org.springframework.cloud.sleuth.instrument.web.WebFluxSleuthOperators;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

class ManualRequestSender
extends RequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManualRequestSender.class);

    ManualRequestSender(WebClient webClient, Tracer tracer) {
        super(webClient, tracer);
    }

    @Override
    public Mono<String> get(Integer someParameterNotUsedNow) {
        return Mono.just((Object)this.webClient).doOnEach(WebFluxSleuthOperators.withSpanInScope((SignalType)SignalType.ON_NEXT, () -> {
            this.span = this.tracer.currentSpan();
            LOGGER.info("getting for parameter {}", (Object)someParameterNotUsedNow);
        })).flatMap(webClient -> Mono.subscriberContext().flatMap(ctx -> (Mono)WebFluxSleuthOperators.withSpanInScope((Context)ctx, () -> ((WebClient.RequestBodySpec)webClient.method(HttpMethod.GET).uri("http://localhost:" + this.port + "/foo", new Object[0])).retrieve().bodyToMono(String.class))));
    }

    @Override
    public Flux<String> getAll() {
        return Flux.just((Object)"").flatMap(s -> Flux.deferWithContext(ctx -> Flux.just((Object)"").doOnNext(t -> WebFluxSleuthOperators.withSpanInScope((Context)ctx, () -> LOGGER.info("before merge"))).mergeWith(this.get(2)).mergeWith(this.get(3)).doOnNext(t -> WebFluxSleuthOperators.withSpanInScope((Context)ctx, () -> LOGGER.info("after merge")))));
    }
}

