/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpResponseParser;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class HttpServerParserTests {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @LocalServerPort
    int port;
    @Autowired
    FooController fooController;

    @AfterEach
    @BeforeEach
    public void close() {
        this.spans.clear();
        this.fooController.clear();
    }

    @Test
    public void should_set_tags_via_server_parsers() {
        BDDAssertions.then((String)((String)new RestTemplate().getForObject("http://localhost:" + this.port + "/hello", String.class, new Object[0]))).isEqualTo("hello");
        Awaitility.await().untilAsserted(() -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)((MapAssert)((MapAssert)BDDAssertions.then(this.serverSideTags()).containsEntry((Object)"ServerRequest", (Object)"Tag")).containsEntry((Object)"ServerRequestServlet", (Object)"GET")).containsEntry((Object)"ServerResponse", (Object)"Tag")).containsEntry((Object)"ServerResponseServlet", (Object)"200");
        });
    }

    protected Map<String, String> serverSideTags() {
        return this.spans.reportedSpans().stream().filter(f -> f.getKind().equals((Object)Span.Kind.SERVER)).flatMap(f -> f.getTags().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Configuration(proxyBeanMethods=false)
    public static class ServerParserConfiguration {
        @Bean(name={"sleuthHttpServerRequestParser"})
        HttpRequestParser myHttpRequestParser() {
            return (request, context, span) -> {
                span.tag("ServerRequest", "Tag");
                Object unwrap = request.unwrap();
                if (unwrap instanceof HttpServletRequest) {
                    HttpServletRequest req = (HttpServletRequest)unwrap;
                    span.tag("ServerRequestServlet", req.getMethod());
                }
            };
        }

        @Bean(name={"sleuthHttpServerResponseParser"})
        HttpResponseParser myHttpResponseParser() {
            return (response, context, span) -> {
                span.tag("ServerResponse", "Tag");
                Object unwrap = response.unwrap();
                if (unwrap instanceof HttpServletResponse) {
                    HttpServletResponse resp = (HttpServletResponse)unwrap;
                    span.tag("ServerResponseServlet", String.valueOf(resp.getStatus()));
                }
            };
        }
    }

    @RestController
    public static class FooController {
        Span span;

        @RequestMapping(value={"/hello"}, method={RequestMethod.GET})
        public String hello() {
            return "hello";
        }

        public Span getSpan() {
            return this.span;
        }

        public void clear() {
            this.span = null;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration(exclude={JmxAutoConfiguration.class})
    @Import(value={ServerParserConfiguration.class})
    public static class TestConfiguration {
        @Bean
        FooController fooController() {
            return new FooController();
        }
    }
}

