/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanName;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;

@ExtendWith(value={MockitoExtension.class})
public abstract class TraceRunnableTests
implements TestTracingAwareSupplier {
    ExecutorService executor = Executors.newSingleThreadExecutor();

    @AfterEach
    public void clean() {
        this.executor.shutdown();
    }

    @Test
    public void should_remove_span_from_thread_local_after_finishing_work() throws Exception {
        TraceKeepingRunnable traceKeepingRunnable = this.runnableThatRetrievesTraceFromThreadLocal();
        this.givenRunnableGetsSubmitted(traceKeepingRunnable);
        Span firstSpan = traceKeepingRunnable.span;
        ((ObjectAssert)BDDAssertions.then((Object)firstSpan).as("first span", new Object[0])).isNotNull();
        this.whenRunnableGetsSubmitted(traceKeepingRunnable);
        Span secondSpan = traceKeepingRunnable.span;
        ((AbstractStringAssert)((AbstractStringAssert)BDDAssertions.then((String)secondSpan.context().traceId()).as("second span id", new Object[0])).isNotEqualTo((Object)firstSpan.context().traceId())).as("first span id", new Object[0]);
        this.assertThatThereIsNoParentId(secondSpan);
    }

    protected void assertThatThereIsNoParentId(Span secondSpan) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    @Test
    public void should_not_find_thread_local_in_non_traceable_callback() throws Exception {
        TraceKeepingRunnable traceKeepingRunnable = this.runnableThatRetrievesTraceFromThreadLocal();
        this.givenRunnableGetsSubmitted(traceKeepingRunnable);
        Span firstSpan = traceKeepingRunnable.span;
        ((ObjectAssert)BDDAssertions.then((Object)firstSpan).as("expected span", new Object[0])).isNotNull();
        this.whenNonTraceableRunnableGetsSubmitted(traceKeepingRunnable);
        Span secondSpan = traceKeepingRunnable.span;
        ((ObjectAssert)BDDAssertions.then((Object)secondSpan).as("unexpected span", new Object[0])).isNull();
    }

    @Test
    public void should_take_name_of_span_from_span_name_annotation() throws Exception {
        TraceKeepingRunnable traceKeepingRunnable = this.runnableThatRetrievesTraceFromThreadLocal();
        this.whenRunnableGetsSubmitted(traceKeepingRunnable);
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).hasSize(1);
        BDDAssertions.then((String)this.tracerTest().handler().reportedSpans().get(0).getName()).isEqualTo("some-runnable-name-from-annotation");
    }

    @Test
    public void should_take_name_of_span_from_to_string_if_span_name_annotation_is_missing() throws Exception {
        AtomicReference<Span> span = new AtomicReference<Span>();
        Runnable runnable = this.runnableWithCustomToString(span);
        this.whenRunnableGetsSubmitted(runnable);
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).hasSize(1);
        BDDAssertions.then((String)this.tracerTest().handler().reportedSpans().get(0).getName()).isEqualTo("some-runnable-name-from-to-string");
    }

    private TraceKeepingRunnable runnableThatRetrievesTraceFromThreadLocal() {
        return new TraceKeepingRunnable(this.tracerTest().tracing().tracer());
    }

    private void givenRunnableGetsSubmitted(Runnable runnable) throws Exception {
        this.whenRunnableGetsSubmitted(runnable);
    }

    private void whenRunnableGetsSubmitted(Runnable runnable) throws Exception {
        this.executor.submit((Runnable)new TraceRunnable(this.tracerTest().tracing().tracer(), (SpanNamer)new DefaultSpanNamer(), runnable)).get();
    }

    private void whenNonTraceableRunnableGetsSubmitted(Runnable runnable) throws Exception {
        this.executor.submit(runnable).get();
    }

    private Runnable runnableWithCustomToString(final AtomicReference<Span> span) {
        return new Runnable(){

            @Override
            public void run() {
                span.set(TraceRunnableTests.this.tracerTest().tracing().tracer().currentSpan());
            }

            public String toString() {
                return "some-runnable-name-from-to-string";
            }
        };
    }

    @SpanName(value="some-runnable-name-from-annotation")
    static class TraceKeepingRunnable
    implements Runnable {
        private final Tracer tracer;
        public Span span;

        TraceKeepingRunnable(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public void run() {
            this.span = this.tracer.currentSpan();
        }
    }
}

