/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import java.util.function.Function;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;

public final class EventPublishingContextWrapper
implements Function<ContextStorage, ContextStorage> {
    private final ApplicationEventPublisher publisher;

    public EventPublishingContextWrapper(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public ContextStorage apply(final ContextStorage contextStorage) {
        return new ContextStorage(){

            public Scope attach(Context context) {
                Context currentContext = Context.current();
                Scope scope = contextStorage.attach(context);
                if (scope == Scope.noop()) {
                    return scope;
                }
                EventPublishingContextWrapper.this.publisher.publishEvent((ApplicationEvent)new ScopeAttachedEvent(this, context));
                return () -> {
                    scope.close();
                    EventPublishingContextWrapper.this.publisher.publishEvent((ApplicationEvent)new ScopeClosedEvent(this));
                    EventPublishingContextWrapper.this.publisher.publishEvent((ApplicationEvent)new ScopeRestoredEvent(this, currentContext));
                };
            }

            public Context current() {
                return contextStorage.current();
            }
        };
    }

    public static class ScopeRestoredEvent
    extends ApplicationEvent {
        final Context context;

        public ScopeRestoredEvent(Object source, @Nullable Context context) {
            super(source);
            this.context = context;
        }

        Span getSpan() {
            return Span.fromContextOrNull((Context)this.context);
        }

        Baggage getBaggage() {
            return Baggage.fromContextOrNull((Context)this.context);
        }

        public String toString() {
            return "ScopeRestored{context: [span: " + this.getSpan() + "] [baggage: " + this.getBaggage() + "]}";
        }
    }

    public static class ScopeClosedEvent
    extends ApplicationEvent {
        public ScopeClosedEvent(Object source) {
            super(source);
        }
    }

    public static class ScopeAttachedEvent
    extends ApplicationEvent {
        final Context context;

        public ScopeAttachedEvent(Object source, @Nullable Context context) {
            super(source);
            this.context = context;
        }

        Span getSpan() {
            return Span.fromContextOrNull((Context)this.context);
        }

        Baggage getBaggage() {
            return Baggage.fromContextOrNull((Context)this.context);
        }

        public String toString() {
            return "ScopeAttached{context: [span: " + this.getSpan() + "] [baggage: " + this.getBaggage() + "]}";
        }
    }
}

