/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;

public class OtelFinishedSpan
implements FinishedSpan {
    private final SpanData spanData;
    private final Map<String, String> tags = new HashMap<String, String>();
    private volatile String linkLocalIp;

    OtelFinishedSpan(SpanData spanData) {
        this.spanData = spanData;
    }

    public static FinishedSpan fromOtel(SpanData span) {
        return new OtelFinishedSpan(span);
    }

    public static SpanData toOtel(FinishedSpan span) {
        return ((OtelFinishedSpan)span).spanData;
    }

    public String getName() {
        return this.spanData.getName();
    }

    public long getStartTimestamp() {
        return this.spanData.getStartEpochNanos();
    }

    public long getEndTimestamp() {
        return this.spanData.getEndEpochNanos();
    }

    public Map<String, String> getTags() {
        if (this.tags.isEmpty()) {
            this.spanData.getAttributes().forEach((key, value) -> this.tags.put(key.getKey(), String.valueOf(value)));
        }
        return this.tags;
    }

    public Collection<Map.Entry<Long, String>> getEvents() {
        return this.spanData.getEvents().stream().map(e -> new AbstractMap.SimpleEntry<Long, String>(e.getEpochNanos(), e.getName())).collect(Collectors.toList());
    }

    public String getSpanId() {
        return this.spanData.getSpanId();
    }

    public String getParentId() {
        return this.spanData.getParentSpanId();
    }

    public String getRemoteIp() {
        return this.getTags().get("net.peer.ip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalIp() {
        if (this.linkLocalIp != null) {
            return this.linkLocalIp;
        }
        OtelFinishedSpan otelFinishedSpan = this;
        synchronized (otelFinishedSpan) {
            if (this.linkLocalIp == null) {
                this.linkLocalIp = this.produceLinkLocalIp();
            }
        }
        return this.linkLocalIp;
    }

    private String produceLinkLocalIp() {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> addresses = nic.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isSiteLocalAddress()) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getRemotePort() {
        return Integer.parseInt(this.getTags().get("net.peer.port"));
    }

    public String getTraceId() {
        return this.spanData.getTraceId();
    }

    public Throwable getError() {
        Attributes attributes = this.spanData.getEvents().stream().filter(e -> e.getName().equals("exception")).findFirst().map(EventData::getAttributes).orElse(null);
        if (attributes != null) {
            return new AssertingThrowable(attributes);
        }
        return null;
    }

    public Span.Kind getKind() {
        if (this.spanData.getKind() == SpanKind.INTERNAL) {
            return null;
        }
        return Span.Kind.valueOf((String)this.spanData.getKind().name());
    }

    public String getRemoteServiceName() {
        return (String)this.spanData.getAttributes().get(AttributeKey.stringKey((String)"peer.service"));
    }

    public String toString() {
        return "SpanDataToReportedSpan{spanData=" + this.spanData + ", tags=" + this.tags + '}';
    }

    public static class AssertingThrowable
    extends Throwable {
        public final Attributes attributes;

        AssertingThrowable(Attributes attributes) {
            super((String)attributes.get(AttributeKey.stringKey((String)"exception.message")));
            this.attributes = attributes;
        }
    }
}

