/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelLogProperties;
import org.springframework.cloud.sleuth.otel.bridge.Slf4jApplicationListener;
import org.springframework.cloud.sleuth.otel.bridge.Slf4jBaggageApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OtelLogProperties.class})
class OtelLogConfiguration {
    OtelLogConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={LoggingSpanExporter.class})
    @ConditionalOnProperty(value={"spring.sleuth.otel.log.exporter.enabled"}, matchIfMissing=true)
    static class LoggingExporterConfiguration {
        LoggingExporterConfiguration() {
        }

        @Bean
        LoggingSpanExporter otelLoggingSpanExporter() {
            return new LoggingSpanExporter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MDC.class})
    @ConditionalOnProperty(value={"spring.sleuth.otel.log.slf4j.enabled"}, matchIfMissing=true)
    static class Slf4jConfiguration {
        Slf4jConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        Slf4jApplicationListener otelSlf4jApplicationListener() {
            return new Slf4jApplicationListener();
        }

        @Bean
        @ConditionalOnMissingBean
        Slf4jBaggageApplicationListener otelSlf4jBaggageApplicationListener(SleuthBaggageProperties baggageProperties) {
            return new Slf4jBaggageApplicationListener(baggageProperties.getCorrelationFields());
        }
    }
}

