/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.SleuthAnnotationConfiguration;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthSpanFilterProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthTracerProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.otel.ConditionalOnOtelEnabled;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelBridgeConfiguration;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelProcessorProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelPropagationConfiguration;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelResourceConfiguration;
import org.springframework.cloud.sleuth.autoconfig.otel.SpanProcessorProvider;
import org.springframework.cloud.sleuth.internal.SleuthContextListener;
import org.springframework.cloud.sleuth.otel.bridge.SpanExporterCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={io.opentelemetry.api.trace.Tracer.class, OtelProperties.class})
@ConditionalOnOtelEnabled
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@ConditionalOnMissingBean(value={Tracer.class})
@EnableConfigurationProperties(value={OtelProperties.class, SleuthSpanFilterProperties.class, SleuthBaggageProperties.class, SleuthTracerProperties.class, OtelProcessorProperties.class})
@Import(value={OtelBridgeConfiguration.class, OtelPropagationConfiguration.class, TraceConfiguration.class, SleuthAnnotationConfiguration.class, OtelResourceConfiguration.class})
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
public class OtelAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    OpenTelemetry otel(SdkTracerProvider tracerProvider, ContextPropagators contextPropagators) {
        return OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(contextPropagators).build();
    }

    @Bean
    @ConditionalOnMissingBean
    SdkTracerProvider otelTracerProvider(SpanLimits spanLimits, ObjectProvider<List<SpanProcessor>> spanProcessors, SpanExporterCustomizer spanExporterCustomizer, ObjectProvider<List<SpanExporter>> spanExporters, Sampler sampler, Resource resource, SpanProcessorProvider spanProcessorProvider) {
        SdkTracerProviderBuilder sdkTracerProviderBuilder = SdkTracerProvider.builder().setResource(resource).setSampler(sampler).setSpanLimits(spanLimits);
        List processors = (List)spanProcessors.getIfAvailable(ArrayList::new);
        processors.addAll(((List)spanExporters.getIfAvailable(ArrayList::new)).stream().map(e -> spanProcessorProvider.toSpanProcessor(spanExporterCustomizer.customize(e))).collect(Collectors.toList()));
        processors.forEach(arg_0 -> ((SdkTracerProviderBuilder)sdkTracerProviderBuilder).addSpanProcessor(arg_0));
        return sdkTracerProviderBuilder.build();
    }

    @Bean
    @ConditionalOnClass(name={"io.opentelemetry.api.metrics.GlobalMeterProvider"})
    @ConditionalOnMissingBean
    SpanProcessorProvider otelBatchSpanProcessorProvider(final OtelProcessorProperties otelProcessorProperties) {
        return new SpanProcessorProvider(){

            @Override
            public SpanProcessor toSpanProcessor(SpanExporter spanExporter) {
                BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder((SpanExporter)spanExporter);
                this.setBuilderProperties(otelProcessorProperties, builder);
                return builder.build();
            }

            private void setBuilderProperties(OtelProcessorProperties otelProcessorProperties2, BatchSpanProcessorBuilder builder) {
                if (otelProcessorProperties2.getBatch().getExporterTimeout() != null) {
                    builder.setExporterTimeout(otelProcessorProperties2.getBatch().getExporterTimeout().longValue(), TimeUnit.MILLISECONDS);
                }
                if (otelProcessorProperties2.getBatch().getMaxExportBatchSize() != null) {
                    builder.setMaxExportBatchSize(otelProcessorProperties2.getBatch().getMaxExportBatchSize().intValue());
                }
                if (otelProcessorProperties2.getBatch().getMaxQueueSize() != null) {
                    builder.setMaxQueueSize(otelProcessorProperties2.getBatch().getMaxQueueSize().intValue());
                }
                if (otelProcessorProperties2.getBatch().getScheduleDelay() != null) {
                    builder.setScheduleDelay(otelProcessorProperties2.getBatch().getScheduleDelay().longValue(), TimeUnit.MILLISECONDS);
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingClass(value={"io.opentelemetry.api.metrics.GlobalMeterProvider"})
    @ConditionalOnMissingBean
    SpanProcessorProvider otelSimpleSpanProcessorProvider() {
        return SimpleSpanProcessor::create;
    }

    @Bean
    @ConditionalOnMissingBean
    Resource otelResource(Environment env, ObjectProvider<List<Supplier<Resource>>> resourceProviders) {
        String applicationName = env.getProperty("spring.application.name");
        Resource resource = this.defaultResource(applicationName);
        List resourceCustomizers = (List)resourceProviders.getIfAvailable(ArrayList::new);
        for (Supplier provider : resourceCustomizers) {
            resource = resource.merge((Resource)provider.get());
        }
        return resource;
    }

    private Resource defaultResource(String applicationName) {
        if (applicationName == null) {
            return Resource.getDefault();
        }
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)applicationName)));
    }

    @Bean
    @ConditionalOnMissingBean
    SpanLimits otelSpanLimits(OtelProperties otelProperties) {
        return SpanLimits.getDefault().toBuilder().setMaxNumberOfAttributes(otelProperties.getMaxAttrs()).setMaxNumberOfAttributesPerEvent(otelProperties.getMaxEventAttrs()).setMaxNumberOfAttributesPerLink(otelProperties.getMaxLinkAttrs()).setMaxNumberOfEvents(otelProperties.getMaxEvents()).setMaxNumberOfLinks(otelProperties.getMaxLinks()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    io.opentelemetry.api.trace.Tracer otelTracer(TracerProvider tracerProvider, OtelProperties otelProperties) {
        return tracerProvider.get(otelProperties.getInstrumentationName());
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler otelSampler(OtelProperties otelProperties) {
        Sampler rootSampler = Sampler.traceIdRatioBased((double)otelProperties.getTraceIdRatioBased());
        return Sampler.parentBased((Sampler)rootSampler);
    }

    @Bean
    SleuthContextListener sleuthContextListener() {
        return new SleuthContextListener();
    }
}

