/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.internal;

import java.util.Arrays;
import org.springframework.cloud.sleuth.internal.HexCodec;
import org.springframework.util.Assert;

public final class EncodingUtils {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    static final int LONG_BYTES = 8;
    static final int BYTE_BASE16 = 2;
    static final int LONG_BASE16 = 16;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final char[] ENCODING = EncodingUtils.buildEncodingArray();
    private static final byte[] DECODING = EncodingUtils.buildDecodingArray();

    private EncodingUtils() {
    }

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    public static long[] fromString(CharSequence chars) {
        if (chars == null || chars.length() == 0) {
            return new long[]{0L};
        }
        if (chars.length() == 32) {
            long high = HexCodec.lenientLowerHexToUnsignedLong(chars, 0, 16);
            long low = HexCodec.lenientLowerHexToUnsignedLong(chars, 16, 32);
            return new long[]{high, low};
        }
        return new long[]{HexCodec.lenientLowerHexToUnsignedLong(chars, 0, 16)};
    }

    public static long longFromBase16String(CharSequence chars) {
        return EncodingUtils.longFromBase16String(chars, 0);
    }

    static long longFromBase16String(CharSequence chars, int offset) {
        Assert.isTrue((chars.length() >= offset + 16 ? 1 : 0) != 0, (String)"chars too small");
        return ((long)EncodingUtils.decodeByte(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)EncodingUtils.decodeByte(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)EncodingUtils.decodeByte(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    public static byte byteFromBase16String(CharSequence chars, int offset) {
        Assert.isTrue((chars.length() >= offset + 2 ? 1 : 0) != 0, (String)"chars too small");
        return EncodingUtils.decodeByte(chars.charAt(offset), chars.charAt(offset + 1));
    }

    private static byte decodeByte(char hi, char lo) {
        Assert.isTrue((lo < '\u0080' && DECODING[lo] != -1 ? 1 : 0) != 0, (String)("invalid character " + lo));
        Assert.isTrue((hi < '\u0080' && DECODING[hi] != -1 ? 1 : 0) != 0, (String)("invalid character " + hi));
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }

    public static boolean isValidBase16String(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char b = value.charAt(i);
            if (EncodingUtils.isDigit(b) || EncodingUtils.isLowercaseHexCharacter(b)) continue;
            return false;
        }
        return true;
    }

    public static String fromLong(long id) {
        return EncodingUtils.fromLongs(0L, id);
    }

    public static String fromLongs(long idHigh, long idLow) {
        if (idHigh == 0L) {
            return HexCodec.toLowerHex(idLow);
        }
        char[] chars = EncodingUtils.getTemporaryBuffer();
        EncodingUtils.longToBase16String(idHigh, chars, 0);
        EncodingUtils.longToBase16String(idLow, chars, 16);
        return new String(chars);
    }

    public static void longToBase16String(long value, char[] dest, int destOffset) {
        EncodingUtils.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        EncodingUtils.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        EncodingUtils.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        EncodingUtils.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        EncodingUtils.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        EncodingUtils.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        EncodingUtils.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        EncodingUtils.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    public static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[32];
            charBuffer.set(chars);
        }
        return chars;
    }

    private static boolean isLowercaseHexCharacter(char b) {
        return 'a' <= b && b <= 'f';
    }

    private static boolean isDigit(char b) {
        return '0' <= b && b <= '9';
    }
}

