/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceFunction;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class TraceReactiveCircuitBreaker
implements ReactiveCircuitBreaker {
    private final ReactiveCircuitBreaker delegate;
    private final Tracer tracer;
    private final CurrentTraceContext currentTraceContext;

    TraceReactiveCircuitBreaker(ReactiveCircuitBreaker delegate, Tracer tracer, CurrentTraceContext currentTraceContext) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.currentTraceContext = currentTraceContext;
    }

    public <T> Mono<T> run(Mono<T> toRun) {
        return this.runAndTraceMono(() -> this.delegate.run(toRun));
    }

    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        return this.runAndTraceMono(() -> this.delegate.run(toRun, (Function)(fallback != null ? new TraceFunction(this.tracer, fallback) : null)));
    }

    public <T> Flux<T> run(Flux<T> toRun) {
        return this.runAndTraceFlux(() -> this.delegate.run(toRun));
    }

    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        return this.runAndTraceFlux(() -> this.delegate.run(toRun, (Function)(fallback != null ? new TraceFunction(this.tracer, fallback) : null)));
    }

    private <T> Mono<T> runAndTraceMono(Supplier<Mono<T>> mono) {
        return ReactorSleuth.tracedMono(this.tracer, this.currentTraceContext, "function", mono);
    }

    private <T> Flux<T> runAndTraceFlux(Supplier<Flux<T>> flux) {
        return ReactorSleuth.tracedFlux(this.tracer, this.currentTraceContext, "function", flux);
    }
}

