/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.deployer;

import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.TagKey;

enum SleuthDeployerSpan implements DocumentedSpan
{
    DEPLOYER_DEPLOY_SPAN{

        public String getName() {
            return "deploy";
        }

        public TagKey[] getTagKeys() {
            return Tags.values();
        }

        public EventValue[] getEvents() {
            return Events.values();
        }
    }
    ,
    DEPLOYER_UNDEPLOY_SPAN{

        public String getName() {
            return "undeploy";
        }

        public TagKey[] getTagKeys() {
            return Tags.values();
        }

        public EventValue[] getEvents() {
            return Events.values();
        }
    }
    ,
    DEPLOYER_STATUS_SPAN{

        public String getName() {
            return "status";
        }

        public TagKey[] getTagKeys() {
            return Tags.values();
        }

        public EventValue[] getEvents() {
            return Events.values();
        }
    }
    ,
    DEPLOYER_STATUSES_SPAN{

        public String getName() {
            return "statuses";
        }

        public TagKey[] getTagKeys() {
            return Tags.values();
        }

        public EventValue[] getEvents() {
            return Events.values();
        }
    }
    ,
    DEPLOYER_GET_LOG_SPAN{

        public String getName() {
            return "getLog";
        }

        public TagKey[] getTagKeys() {
            return Tags.values();
        }

        public EventValue[] getEvents() {
            return Events.values();
        }
    }
    ,
    DEPLOYER_SCALE_SPAN{

        public String getName() {
            return "scale";
        }

        public TagKey[] getTagKeys() {
            return TagKey.merge((TagKey[][])new TagKey[][]{Tags.values(), ScaleTags.values()});
        }

        public EventValue[] getEvents() {
            return Events.values();
        }
    };


    static enum Events implements EventValue
    {
        DEPLOYER_START{

            public String getValue() {
                return "deployer.start";
            }
        }
        ,
        DEPLOYER_STATUS_CHANGE{

            public String getValue() {
                return "%s";
            }
        };

    }

    static enum ScaleTags implements TagKey
    {
        DEPLOYER_SCALE_DEPLOYMENT_ID{

            public String getKey() {
                return "deployer.scale.deploymentId";
            }
        }
        ,
        DEPLOYER_SCALE_COUNT{

            public String getKey() {
                return "deployer.scale.count";
            }
        };

    }

    static enum Tags implements TagKey
    {
        PLATFORM_NAME{

            public String getKey() {
                return "deployer.platform.name";
            }
        }
        ,
        APP_ID{

            public String getKey() {
                return "deployer.app.id";
            }
        }
        ,
        APP_NAME{

            public String getKey() {
                return "deployer.app.name";
            }
        }
        ,
        APP_GROUP{

            public String getKey() {
                return "deployer.app.group";
            }
        }
        ,
        CF_URL{

            public String getKey() {
                return "deployer.platform.cf.url";
            }
        }
        ,
        CF_ORG{

            public String getKey() {
                return "deployer.platform.cf.org";
            }
        }
        ,
        CF_SPACE{

            public String getKey() {
                return "deployer.platform.cf.space";
            }
        }
        ,
        K8S_URL{

            public String getKey() {
                return "deployer.platform.k8s.url";
            }
        }
        ,
        K8S_NAMESPACE{

            public String getKey() {
                return "deployer.platform.k8s.namespace";
            }
        };

    }
}

