/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

class TraceRetryableFeignBlockingLoadBalancerClient
extends RetryableFeignBlockingLoadBalancerClient {
    private static final Log LOG = LogFactory.getLog(TraceRetryableFeignBlockingLoadBalancerClient.class);
    private final BeanFactory beanFactory;
    Tracer tracer;
    CurrentTraceContext currentTraceContext;
    HttpClientHandler httpClientHandler;
    TracingFeignClient tracingFeignClient;

    TraceRetryableFeignBlockingLoadBalancerClient(Client delegate, BlockingLoadBalancerClient loadBalancerClient, LoadBalancedRetryFactory retryFactory, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory, BeanFactory beanFactory) {
        super(delegate, (LoadBalancerClient)loadBalancerClient, retryFactory, properties, loadBalancerClientFactory);
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Before send");
        }
        Response response = null;
        Span fallbackSpan = this.tracer().nextSpan().start();
        try {
            response = this.delegateIsALoadBalancer() ? this.getDelegate().execute(request, options) : super.execute(request, options);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"After receive");
            }
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception thrown", (Throwable)e);
            }
            if (e instanceof IOException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"IOException was thrown, so most likely the traced client wasn't called. Falling back to a manual span.");
                }
                this.tracingFeignClient().handleSendAndReceive(fallbackSpan, request, response, e);
            }
            throw e;
        }
        finally {
            fallbackSpan.abandon();
        }
    }

    private boolean delegateIsALoadBalancer() {
        return this.getDelegate() instanceof RetryableFeignBlockingLoadBalancerClient;
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    private HttpClientHandler httpClientHandler() {
        if (this.httpClientHandler == null) {
            this.httpClientHandler = (HttpClientHandler)this.beanFactory.getBean(HttpClientHandler.class);
        }
        return this.httpClientHandler;
    }

    private TracingFeignClient tracingFeignClient() {
        if (this.tracingFeignClient == null) {
            this.tracingFeignClient = (TracingFeignClient)TracingFeignClient.create(this.currentTraceContext(), this.httpClientHandler(), this.getDelegate());
        }
        return this.tracingFeignClient;
    }
}

