/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.function.context.catalog.FunctionAroundWrapper;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.FunctionMessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpan;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpans;
import org.springframework.cloud.sleuth.instrument.messaging.TraceMessageHandler;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class TraceFunctionAroundWrapper
extends FunctionAroundWrapper
implements ApplicationListener<RefreshScopeRefreshedEvent> {
    private static final Log log = LogFactory.getLog(TraceFunctionAroundWrapper.class);
    private final Environment environment;
    private final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Setter<MessageHeaderAccessor> injector;
    private final Propagator.Getter<MessageHeaderAccessor> extractor;
    private final TraceMessageHandler traceMessageHandler;
    private final List<FunctionMessageSpanCustomizer> customizers;
    final Map<String, String> functionToDestinationCache = new ConcurrentHashMap<String, String>();

    public TraceFunctionAroundWrapper(Environment environment, Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> injector, Propagator.Getter<MessageHeaderAccessor> extractor) {
        this(environment, tracer, propagator, injector, extractor, Collections.emptyList());
    }

    public TraceFunctionAroundWrapper(Environment environment, Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> injector, Propagator.Getter<MessageHeaderAccessor> extractor, List<FunctionMessageSpanCustomizer> customizers) {
        this.environment = environment;
        this.tracer = tracer;
        this.propagator = propagator;
        this.injector = injector;
        this.extractor = extractor;
        this.customizers = customizers;
        this.traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(this.tracer, this.propagator, this.injector, this.extractor, this.customizers);
    }

    protected Object doApply(Message<byte[]> message, SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction) {
        Object result;
        Span span;
        if (FunctionTypeUtils.isCollectionOfMessage((Type)targetFunction.getOutputType()) || targetFunction.isOutputTypePublisher() || targetFunction.isSupplier() && targetFunction.isOutputTypePublisher()) {
            return targetFunction.apply(message);
        }
        MessageAndSpans invocationMessage = null;
        if (message == null && targetFunction.isSupplier()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a span for a supplier");
            }
            span = this.tracer.nextSpan().name(targetFunction.getFunctionDefinition());
            this.customizedInputMessageSpan(span, null);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will retrieve the tracing headers from the message");
            }
            invocationMessage = this.traceMessageHandler.wrapInputMessage(message, this.inputDestination(targetFunction.getFunctionDefinition()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrapped input msg " + invocationMessage));
            }
            span = invocationMessage.childSpan;
        }
        Exception throwable = null;
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            result = invocationMessage == null ? targetFunction.get() : targetFunction.apply((Object)invocationMessage.msg);
        }
        catch (Exception e) {
            throwable = e;
            throw e;
        }
        finally {
            this.traceMessageHandler.afterMessageHandled(span, throwable);
        }
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Returned message is null - we have a consumer");
            }
            return null;
        }
        Message<?> msgResult = this.toMessage(result);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will instrument the output message");
        }
        MessageAndSpan wrappedOutputMessage = invocationMessage != null ? this.traceMessageHandler.wrapOutputMessage(msgResult, invocationMessage.parentSpan, this.outputDestination(targetFunction.getFunctionDefinition())) : this.getMessageAndSpans(msgResult, targetFunction.getFunctionDefinition(), span);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrapped output msg " + wrappedOutputMessage));
        }
        this.traceMessageHandler.afterMessageHandled(wrappedOutputMessage.span, null);
        return wrappedOutputMessage.msg;
    }

    MessageAndSpan getMessageAndSpans(Message<?> resultMessage, String name, Span spanFromMessage) {
        return this.traceMessageHandler.wrapOutputMessage(resultMessage, spanFromMessage, this.outputDestination(name));
    }

    private void customizedInputMessageSpan(Span spanToCustomize, Message<?> msg) {
        this.customizers.forEach(cust -> cust.customizeInputMessageSpan(spanToCustomize, msg));
    }

    private Message<?> toMessage(Object result) {
        if (!(result instanceof Message)) {
            return MessageBuilder.withPayload((Object)result).build();
        }
        return (Message)result;
    }

    String inputDestination(String functionDefinition) {
        return this.functionToDestinationCache.computeIfAbsent(functionDefinition, s -> {
            String bindingMappingProperty = "spring.cloud.stream.function.bindings." + s + "-in-0";
            String bindingProperty = this.environment.containsProperty(bindingMappingProperty) ? this.environment.getProperty(bindingMappingProperty) : s + "-in-0";
            return this.environment.getProperty("spring.cloud.stream.bindings." + bindingProperty + ".destination", s);
        });
    }

    String outputDestination(String functionDefinition) {
        return this.functionToDestinationCache.computeIfAbsent(functionDefinition, s -> {
            String bindingMappingProperty = "spring.cloud.stream.function.bindings." + s + "-out-0";
            String bindingProperty = this.environment.containsProperty(bindingMappingProperty) ? this.environment.getProperty(bindingMappingProperty) : s + "-out-0";
            return this.environment.getProperty("spring.cloud.stream.bindings." + bindingProperty + ".destination", s);
        });
    }

    public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Context refreshed, will reset the cache");
        }
        this.functionToDestinationCache.clear();
    }
}

