/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpan;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpans;
import org.springframework.cloud.sleuth.instrument.messaging.TraceMessageHandler;
import org.springframework.messaging.Message;

public final class MessagingSleuthOperators {
    private static final Log log = LogFactory.getLog(MessagingSleuthOperators.class);

    private MessagingSleuthOperators() {
        throw new IllegalStateException("You can't instantiate a utility class");
    }

    public static <T> Message<T> forInputMessage(BeanFactory beanFactory, Message<T> message, Consumer<Message<T>> withSpanInScope) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        MessageAndSpans wrappedInputMessage = traceMessageHandler.wrapInputMessage(message, "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrapped input msg " + wrappedInputMessage));
        }
        Exception t = null;
        try (Tracer.SpanInScope ws = traceMessageHandler.tracer.withSpan(wrappedInputMessage.childSpan.start());){
            withSpanInScope.accept(wrappedInputMessage.msg);
        }
        catch (Exception e) {
            t = e;
            throw e;
        }
        finally {
            traceMessageHandler.afterMessageHandled(wrappedInputMessage.childSpan, t);
        }
        return wrappedInputMessage.msg;
    }

    public static <T> Message<T> forInputMessage(BeanFactory beanFactory, Message<T> message) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        MessageAndSpans wrappedInputMessage = traceMessageHandler.wrapInputMessage(message, "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrapped input msg " + wrappedInputMessage));
        }
        return wrappedInputMessage.msg;
    }

    public static <T> Function<Message<T>, Message<T>> asFunction(BeanFactory beanFactory, Message<T> inputMessage) {
        return stringMessage -> MessagingSleuthOperators.forInputMessage(beanFactory, inputMessage);
    }

    public static <T> Span spanFromMessage(BeanFactory beanFactory, Message<T> message) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        return MessagingSleuthOperators.spanFromMessage(traceMessageHandler, message);
    }

    private static <T> Span spanFromMessage(TraceMessageHandler traceMessageHandler, Message<T> message) {
        Span span = traceMessageHandler.spanFromMessage(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following span in message " + span));
        }
        return span;
    }

    public static <T> void withSpanInScope(BeanFactory beanFactory, Message<T> message, Consumer<Message<T>> withSpanInScope) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        Span span = MessagingSleuthOperators.spanFromMessage(traceMessageHandler, message);
        try (Tracer.SpanInScope ws = traceMessageHandler.tracer.withSpan(span);){
            withSpanInScope.accept(message);
        }
    }

    public static <T> Message<T> withSpanInScope(BeanFactory beanFactory, Message<T> message, Function<Message<T>, Message<T>> withSpanInScope) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        Span span = MessagingSleuthOperators.spanFromMessage(traceMessageHandler, message);
        try (Tracer.SpanInScope ws = traceMessageHandler.tracer.withSpan(span);){
            Message<T> message2 = withSpanInScope.apply(message);
            return message2;
        }
    }

    public static <T> Message<T> handleOutputMessage(BeanFactory beanFactory, Message<T> message) {
        return MessagingSleuthOperators.handleOutputMessage(beanFactory, message, null);
    }

    public static <T> Message<T> handleOutputMessage(BeanFactory beanFactory, Message<T> message, Throwable throwable) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        Span span = traceMessageHandler.parentSpan(message);
        Span span2 = span = span != null ? span : traceMessageHandler.consumerSpan(message);
        if (span == null) {
            log.warn((Object)"Can't find neither parent nor consumer span. Will return the message with no tracer header changes");
            return message;
        }
        MessageAndSpan messageAndSpan = traceMessageHandler.wrapOutputMessage(message, span, String.valueOf(message.getHeaders().getOrDefault((Object)"destination", (Object)"")));
        traceMessageHandler.afterMessageHandled(messageAndSpan.span, throwable);
        return messageAndSpan.msg;
    }

    public static <T> Message<T> afterMessageHandled(BeanFactory beanFactory, Message<T> message, Throwable ex) {
        TraceMessageHandler traceMessageHandler = TraceMessageHandler.forNonSpringIntegration(beanFactory);
        Span span = traceMessageHandler.spanFromMessage(message);
        traceMessageHandler.afterMessageHandled(span, ex);
        return message;
    }
}

