/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.aws.AWSPropagation;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.W3CPropagation;
import org.springframework.cloud.sleuth.brave.propagation.PropagationFactorySupplier;
import org.springframework.cloud.sleuth.brave.propagation.PropagationType;

class CompositePropagationFactory
extends Propagation.Factory
implements Propagation<String> {
    private final Map<PropagationType, Map.Entry<Propagation.Factory, Propagation<String>>> mapping = new HashMap<PropagationType, Map.Entry<Propagation.Factory, Propagation<String>>>();
    private final List<PropagationType> types;

    CompositePropagationFactory(BeanFactory beanFactory, BraveBaggageManager braveBaggageManager, List<String> localFields, List<PropagationType> types) {
        this.types = types;
        this.mapping.put(PropagationType.AWS, new AbstractMap.SimpleEntry<Propagation.Factory, Propagation>(AWSPropagation.FACTORY, AWSPropagation.FACTORY.get()));
        Propagation.Factory b3Factory = this.b3Factory();
        this.mapping.put(PropagationType.B3, new AbstractMap.SimpleEntry<Propagation.Factory, Propagation>(b3Factory, b3Factory.get()));
        W3CPropagation w3CPropagation = new W3CPropagation(braveBaggageManager, localFields);
        this.mapping.put(PropagationType.W3C, new AbstractMap.SimpleEntry<W3CPropagation, Propagation<String>>(w3CPropagation, w3CPropagation.get()));
        LazyPropagationFactory lazyPropagationFactory = new LazyPropagationFactory(beanFactory.getBeanProvider(PropagationFactorySupplier.class));
        this.mapping.put(PropagationType.CUSTOM, new AbstractMap.SimpleEntry<LazyPropagationFactory, Propagation<String>>(lazyPropagationFactory, lazyPropagationFactory.get()));
    }

    private Propagation.Factory b3Factory() {
        return B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
    }

    public List<String> keys() {
        return this.types.stream().map(this.mapping::get).flatMap(p -> ((Propagation)p.getValue()).keys().stream()).collect(Collectors.toList());
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (traceContext, request) -> this.types.stream().map(this.mapping::get).forEach(p -> ((Propagation)p.getValue()).injector(setter).inject(traceContext, request));
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        return request -> {
            for (PropagationType type : this.types) {
                TraceContextOrSamplingFlags extract;
                Propagation<String> propagator;
                Map.Entry<Propagation.Factory, Propagation<String>> entry = this.mapping.get((Object)type);
                if (entry == null || (propagator = entry.getValue()) == null || propagator == NoOpPropagation.INSTANCE || (extract = propagator.extractor(getter).extract(request)) == TraceContextOrSamplingFlags.EMPTY) continue;
                return extract;
            }
            return TraceContextOrSamplingFlags.EMPTY;
        };
    }

    public Propagation<String> get() {
        return this;
    }

    public boolean supportsJoin() {
        return this.types.stream().map(this.mapping::get).allMatch(e -> ((Propagation.Factory)e.getKey()).supportsJoin());
    }

    public boolean requires128BitTraceId() {
        return this.types.stream().map(this.mapping::get).allMatch(e -> ((Propagation.Factory)e.getKey()).requires128BitTraceId());
    }

    public TraceContext decorate(TraceContext context) {
        for (PropagationType type : this.types) {
            TraceContext decorate;
            Map.Entry<Propagation.Factory, Propagation<String>> entry = this.mapping.get((Object)type);
            if (entry == null || (decorate = entry.getKey().decorate(context)) == context) continue;
            return decorate;
        }
        return super.decorate(context);
    }

    private static class NoOpPropagation
    extends Propagation.Factory
    implements Propagation<String> {
        static final NoOpPropagation INSTANCE = new NoOpPropagation();

        private NoOpPropagation() {
        }

        public List<String> keys() {
            return Collections.emptyList();
        }

        public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
            return (traceContext, request) -> {};
        }

        public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
            return request -> TraceContextOrSamplingFlags.EMPTY;
        }

        public Propagation<String> get() {
            return this;
        }
    }

    private static final class LazyPropagation
    implements Propagation<String> {
        private final LazyPropagationFactory delegate;
        private volatile Propagation<String> propagation;

        private LazyPropagation(LazyPropagationFactory delegate) {
            this.delegate = delegate;
        }

        private Propagation<String> propagation() {
            if (this.propagation == null) {
                this.propagation = this.delegate.propagationFactory().get();
            }
            return this.propagation;
        }

        public List<String> keys() {
            return this.propagation().keys();
        }

        public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
            return this.propagation().injector(setter);
        }

        public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
            return this.propagation().extractor(getter);
        }
    }

    private static final class LazyPropagationFactory
    extends Propagation.Factory {
        private final ObjectProvider<PropagationFactorySupplier> delegate;
        private volatile Propagation.Factory propagationFactory;

        private LazyPropagationFactory(ObjectProvider<PropagationFactorySupplier> delegate) {
            this.delegate = delegate;
        }

        private Propagation.Factory propagationFactory() {
            if (this.propagationFactory == null) {
                this.propagationFactory = ((PropagationFactorySupplier)this.delegate.getIfAvailable(() -> () -> NoOpPropagation.INSTANCE)).get();
            }
            return this.propagationFactory;
        }

        public Propagation<String> get() {
            return new LazyPropagation(this);
        }

        public boolean supportsJoin() {
            return this.propagationFactory().supportsJoin();
        }

        public boolean requires128BitTraceId() {
            return this.propagationFactory().requires128BitTraceId();
        }

        public TraceContext decorate(TraceContext context) {
            return this.propagationFactory().decorate(context);
        }
    }
}

