/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import java.util.Objects;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.docs.AssertingSpan;

public class BraveSpan
implements Span {
    final brave.Span delegate;

    public BraveSpan(brave.Span delegate) {
        this.delegate = delegate;
    }

    public boolean isNoop() {
        return this.delegate.isNoop();
    }

    public TraceContext context() {
        if (this.delegate == null) {
            return null;
        }
        return new BraveTraceContext(this.delegate.context());
    }

    public Span start() {
        this.delegate.start();
        return this;
    }

    public Span name(String name) {
        this.delegate.name(name);
        return this;
    }

    public Span event(String value) {
        this.delegate.annotate(value);
        return this;
    }

    public Span tag(String key, String value) {
        this.delegate.tag(key, value);
        return this;
    }

    public Span error(Throwable throwable) {
        String message = throwable.getMessage() == null ? throwable.getClass().getSimpleName() : throwable.getMessage();
        this.delegate.tag("error", message);
        this.delegate.error(throwable);
        return this;
    }

    public void end() {
        this.delegate.finish();
    }

    public void abandon() {
        this.delegate.abandon();
    }

    public Span remoteServiceName(String remoteServiceName) {
        this.delegate.remoteServiceName(remoteServiceName);
        return this;
    }

    public Span remoteIpAndPort(String ip, int port) {
        this.delegate.remoteIpAndPort(ip, port);
        return this;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    public static brave.Span toBrave(Span span) {
        BraveSpan unwrap = (BraveSpan)AssertingSpan.unwrap((Span)span);
        if (unwrap == null) {
            return null;
        }
        return unwrap.delegate;
    }

    public static Span fromBrave(brave.Span span) {
        return new BraveSpan(span);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Object unwrapped = o;
        if (o instanceof AssertingSpan) {
            unwrapped = ((AssertingSpan)o).getDelegate();
        }
        if (unwrapped == null || this.getClass() != unwrapped.getClass()) {
            return false;
        }
        BraveSpan braveSpan = (BraveSpan)unwrapped;
        return Objects.equals(this.delegate, braveSpan.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

