/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.baggage.BaggageField;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.BaggageManager;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageInScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;

public class BraveBaggageManager
implements Closeable,
BaggageManager {
    private static final Map<String, BaggageInScope> CACHE = new ConcurrentHashMap<String, BaggageInScope>();

    public Map<String, String> getAllBaggage() {
        return BaggageField.getAllValues();
    }

    public BaggageInScope getBaggage(String name) {
        return this.createBaggage(name);
    }

    public BaggageInScope getBaggage(TraceContext traceContext, String name) {
        return new BraveBaggageInScope(BaggageField.getByName((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext), (String)name));
    }

    public BaggageInScope createBaggage(String name) {
        return CACHE.computeIfAbsent(name, s -> new BraveBaggageInScope(BaggageField.create((String)s)));
    }

    public BaggageInScope createBaggage(String name, String value) {
        return this.createBaggage(name).set(value);
    }

    @Override
    public void close() {
        CACHE.clear();
    }
}

