/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.tx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.transaction.TransactionManager;
import org.springframework.util.ReflectionUtils;

abstract class AbstractTransactionManagerInstrumenter<T extends TransactionManager> {
    private static final Log log = LogFactory.getLog(AbstractTransactionManagerInstrumenter.class);
    protected final BeanFactory beanFactory;
    private final Class<T> classToInstrument;

    AbstractTransactionManagerInstrumenter(BeanFactory beanFactory, Class<T> classToInstrument) {
        this.beanFactory = beanFactory;
        this.classToInstrument = classToInstrument;
    }

    private static <T> boolean anyFinalMethods(T object, Class classToCheckAgainst) {
        try {
            for (Method method : ReflectionUtils.getAllDeclaredMethods((Class)classToCheckAgainst)) {
                Method m;
                if (method.getDeclaringClass().equals(Object.class) || (m = ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes())) == null || !Modifier.isPublic(m.getModifiers()) || !Modifier.isFinal(m.getModifiers())) continue;
                return true;
            }
        }
        catch (IllegalAccessError er) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while trying to access methods", (Throwable)er);
            }
            return false;
        }
        return false;
    }

    boolean isApplicableForInstrumentation(Object bean) {
        return this.isNotYetTraced(bean) && !this.tracedClass().isAssignableFrom(bean.getClass());
    }

    private boolean isNotYetTraced(Object bean) {
        return this.classToInstrument.isAssignableFrom(bean.getClass());
    }

    abstract Class tracedClass();

    abstract T wrap(T var1);

    Object instrument(Object bean) {
        if (!this.isApplicableForInstrumentation(bean)) {
            return bean;
        }
        return this.wrapManager(bean);
    }

    private Object wrapManager(Object bean) {
        TransactionManager manager = (TransactionManager)bean;
        boolean methodFinal = AbstractTransactionManagerInstrumenter.anyFinalMethods(manager, this.classToInstrument);
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !methodFinal && !classFinal;
        try {
            return this.createProxy(bean, cglibProxy, (Advice)new TransactionManagerMethodInterceptor<TransactionManager>(this, manager));
        }
        catch (AopConfigException ex) {
            if (cglibProxy) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred while trying to create a proxy, falling back to JDK proxy", (Throwable)ex);
                }
                return this.createProxy(bean, false, (Advice)new TransactionManagerMethodInterceptor<TransactionManager>(this, manager));
            }
            throw ex;
        }
    }

    private Object getObject(ProxyFactoryBean factory) {
        return factory.getObject();
    }

    private Object createProxy(Object bean, boolean cglibProxy, Advice advice) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(advice);
        factory.setTarget(bean);
        return this.getObject(factory);
    }

    static class TransactionManagerMethodInterceptor<T extends TransactionManager>
    implements MethodInterceptor {
        private static final Map<TransactionManager, TransactionManager> CACHE = new ConcurrentHashMap<TransactionManager, TransactionManager>();
        private final AbstractTransactionManagerInstrumenter<T> parent;
        private final T delegate;

        TransactionManagerMethodInterceptor(AbstractTransactionManagerInstrumenter<T> parent, T delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            T tracedDelegate = this.traceDelegate();
            Method methodOnTracedBean = this.getMethod(invocation, tracedDelegate);
            if (methodOnTracedBean != null) {
                try {
                    return methodOnTracedBean.invoke(tracedDelegate, invocation.getArguments());
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    throw cause != null ? cause : ex;
                }
            }
            return invocation.proceed();
        }

        private Method getMethod(MethodInvocation invocation, Object object) {
            Method method = invocation.getMethod();
            return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
        }

        private T traceDelegate() {
            return (T)CACHE.computeIfAbsent((TransactionManager)this.delegate, o -> this.parent.wrap((TransactionManager)o));
        }
    }
}

