/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.HookRegisteringBeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.SleuthReactorProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

class HooksRefresher
implements ApplicationListener<RefreshScopeRefreshedEvent> {
    private static final Log log = LogFactory.getLog(HooksRefresher.class);
    private final SleuthReactorProperties reactorProperties;
    private final ConfigurableApplicationContext context;

    HooksRefresher(SleuthReactorProperties reactorProperties, ConfigurableApplicationContext context) {
        this.reactorProperties = reactorProperties;
        this.context = context;
    }

    public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Context refreshed, will reset hooks and then re-register them");
        }
        Hooks.resetOnEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.resetOnLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.removeQueueWrapper((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Schedulers.resetOnScheduleHook((String)"sleuth");
        switch (this.reactorProperties.getInstrumentationType()) {
            case DECORATE_QUEUES: {
                if (TraceReactorAutoConfiguration.TraceReactorConfiguration.IS_QUEUE_WRAPPER_ON_THE_CLASSPATH) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Adding queue wrapper instrumentation");
                    }
                    HookRegisteringBeanDefinitionRegistryPostProcessor.addQueueWrapper(this.context);
                    Schedulers.onScheduleHook((String)"sleuth", (Function)ReactorSleuth.scopePassingOnScheduleHook((ConfigurableApplicationContext)this.context));
                }
            }
            case DECORATE_ON_EACH: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Decorating onEach operator instrumentation");
                }
                Hooks.onEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.onEachOperatorForOnEachInstrumentation((ConfigurableApplicationContext)this.context));
                Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.onLastOperatorForOnEachInstrumentation((ConfigurableApplicationContext)this.context));
                Schedulers.onScheduleHook((String)"sleuth", (Function)ReactorSleuth.scopePassingOnScheduleHook((ConfigurableApplicationContext)this.context));
                break;
            }
            case DECORATE_ON_LAST: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Decorating onLast operator instrumentation");
                }
                Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)this.context));
                break;
            }
            case MANUAL: {
                Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.springContextSpanOperator((ConfigurableApplicationContext)this.context));
            }
        }
    }
}

