/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web.client.feign;

import feign.Client;
import feign.Feign;
import feign.okhttp.OkHttpClient;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignContextBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.OkHttpFeignClientBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.SleuthFeignBuilder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.feign.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Client.class, FeignContext.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
public class TraceFeignClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    Feign.Builder feignBuilder(BeanFactory beanFactory) {
        return SleuthFeignBuilder.builder((BeanFactory)beanFactory);
    }

    @Bean
    TraceFeignAspect traceFeignAspect(BeanFactory beanFactory) {
        return new TraceFeignAspect(beanFactory);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OkHttpClient.class})
    protected static class OkHttpClientFeignBeanPostProcessorConfiguration {
        protected OkHttpClientFeignBeanPostProcessorConfiguration() {
        }

        @Bean
        static OkHttpFeignClientBeanPostProcessor okHttpFeignClientBeanPostProcessor(BeanFactory beanFactory) {
            return new OkHttpFeignClientBeanPostProcessor(beanFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.sleuth.feign.processor.enabled"}, matchIfMissing=true)
    protected static class FeignBeanPostProcessorConfiguration {
        protected FeignBeanPostProcessorConfiguration() {
        }

        @Bean
        static FeignContextBeanPostProcessor feignContextBeanPostProcessor(BeanFactory beanFactory) {
            return new FeignContextBeanPostProcessor(beanFactory);
        }
    }
}

