/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.docs;

import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpanAssertions;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.ImmutableAssertingSpanCustomizer;
import org.springframework.cloud.sleuth.docs.TagKey;

public interface AssertingSpanCustomizer
extends SpanCustomizer {
    public DocumentedSpan getDocumentedSpan();

    public SpanCustomizer getDelegate();

    @Override
    default public AssertingSpanCustomizer tag(String key, String value) {
        DocumentedSpanAssertions.assertThatKeyIsValid(key, this.getDocumentedSpan());
        this.getDelegate().tag(key, value);
        return this;
    }

    default public AssertingSpanCustomizer tag(TagKey key, String value) {
        DocumentedSpanAssertions.assertThatKeyIsValid(key, this.getDocumentedSpan());
        this.getDelegate().tag(key.getKey(), value);
        return this;
    }

    @Override
    default public AssertingSpanCustomizer event(String value) {
        DocumentedSpanAssertions.assertThatEventIsValid(value, this.getDocumentedSpan());
        this.getDelegate().event(value);
        return this;
    }

    default public AssertingSpanCustomizer event(EventValue value) {
        DocumentedSpanAssertions.assertThatEventIsValid(value, this.getDocumentedSpan());
        this.getDelegate().event(value.getValue());
        return this;
    }

    @Override
    default public AssertingSpanCustomizer name(String name) {
        DocumentedSpanAssertions.assertThatNameIsValid(name, this.getDocumentedSpan());
        this.getDelegate().name(name);
        return this;
    }

    public static AssertingSpanCustomizer of(DocumentedSpan documentedSpan, SpanCustomizer span) {
        if (span instanceof AssertingSpanCustomizer) {
            return (AssertingSpanCustomizer)span;
        }
        return new ImmutableAssertingSpanCustomizer(documentedSpan, span);
    }

    public static <T extends SpanCustomizer> T unwrap(SpanCustomizer span) {
        if (span == null) {
            return null;
        }
        if (span instanceof AssertingSpanCustomizer) {
            return (T)((AssertingSpanCustomizer)span).getDelegate();
        }
        return (T)span;
    }
}

