/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.skipper.domain.AppInstanceStatusImpl;
import org.springframework.cloud.skipper.domain.AppStatusMixin;
import org.springframework.cloud.skipper.domain.NonVersionedAbstractEntity;
import org.springframework.cloud.skipper.domain.StatusCode;

@Entity
@Table(name="SkipperStatus")
public class Status
extends NonVersionedAbstractEntity {
    @Enumerated(value=EnumType.STRING)
    private StatusCode statusCode;
    @Lob
    @Type(type="org.springframework.cloud.dataflow.common.persistence.type.DatabaseAwareLobType")
    private String platformStatus;

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getPlatformStatus() {
        return this.platformStatus;
    }

    public void setPlatformStatus(String platformStatus) {
        this.platformStatus = platformStatus;
    }

    @JsonIgnore
    public void setPlatformStatusAsAppStatusList(List<AppStatus> appStatusList) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            this.platformStatus = objectMapper.writeValueAsString(appStatusList);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize list of Application Status", e);
        }
    }

    @JsonIgnore
    public String getPlatformStatusPrettyPrint() {
        List<AppStatus> appStatusList = this.getAppStatusList();
        StringBuffer statusMsg = new StringBuffer();
        for (AppStatus appStatus : appStatusList) {
            statusMsg.append("[" + appStatus.getDeploymentId() + "]");
            if (appStatus.getInstances().isEmpty()) {
                statusMsg.append(", State = [" + appStatus.getState() + "]\n");
                continue;
            }
            statusMsg.append(", State = [");
            for (AppInstanceStatus appInstanceStatus : appStatus.getInstances().values()) {
                statusMsg.append(appInstanceStatus.getId() + "=" + appInstanceStatus.getState() + "\n");
            }
            statusMsg.setLength(statusMsg.length() - 1);
            statusMsg.append("]\n");
        }
        return statusMsg.toString();
    }

    @JsonIgnore
    public List<DeploymentState> getDeploymentStateList() {
        return this.getAppStatusList().stream().map(appStatus -> appStatus.getState()).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<AppStatus> getAppStatusList() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixIn(AppStatus.class, AppStatusMixin.class);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SimpleModule module = new SimpleModule("CustomModel", Version.unknownVersion());
            SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
            resolver.addMapping(AppInstanceStatus.class, AppInstanceStatusImpl.class);
            module.setAbstractTypes(resolver);
            mapper.registerModule((Module)module);
            TypeReference<List<AppStatus>> typeRef = new TypeReference<List<AppStatus>>(){};
            if (this.platformStatus != null) {
                return (List)mapper.readValue(this.platformStatus, (TypeReference)typeRef);
            }
            return new ArrayList<AppStatus>();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse Skipper Platfrom Status JSON:" + this.platformStatus, e);
        }
    }

    public String toString() {
        return "Status{statusCode=" + (Object)((Object)this.statusCode) + ", platformStatus='" + this.platformStatus + '\'' + '}';
    }
}

