/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.cloud.skipper.domain.CloudFoundryApplicationSkipperManifest;
import org.springframework.cloud.skipper.domain.SkipperManifestKind;
import org.springframework.cloud.skipper.domain.SkipperManifestReader;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class CloudFoundryApplicationManifestReader
implements SkipperManifestReader {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryApplicationManifestReader.class);

    @Override
    public List<CloudFoundryApplicationSkipperManifest> read(String manifest) {
        if (this.canSupport(manifest)) {
            ArrayList<CloudFoundryApplicationSkipperManifest> applicationSpecs = new ArrayList<CloudFoundryApplicationSkipperManifest>();
            YAMLMapper mapper = new YAMLMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
            try {
                MappingIterator it = mapper.readerFor(CloudFoundryApplicationSkipperManifest.class).readValues(manifest);
                while (it.hasNextValue()) {
                    CloudFoundryApplicationSkipperManifest appKind = (CloudFoundryApplicationSkipperManifest)it.next();
                    applicationSpecs.add(appKind);
                }
            }
            catch (JsonMappingException e) {
                logger.error("Can't parse Package's manifest YAML = " + manifest);
                throw new SkipperException("JsonMappingException - Can't parse Package's manifest YAML = " + manifest, e);
            }
            catch (IOException e) {
                logger.error("Can't parse Package's manifest YAML = " + manifest);
                throw new SkipperException("IOException - Can't parse Package's manifest YAML = " + manifest, e);
            }
            return applicationSpecs;
        }
        return Collections.emptyList();
    }

    public boolean canSupport(String manifest) {
        LoaderOptions options = new LoaderOptions();
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(options));
        Iterable object = yaml.loadAll(manifest);
        for (Object o : object) {
            boolean supportKind = this.assertSupportedKind(o);
            if (supportKind) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getSupportedKinds() {
        return new String[]{SkipperManifestKind.CloudFoundryApplication.name()};
    }

    private boolean assertSupportedKind(Object object) {
        if (object == null) {
            throw new SkipperException("Can't parse manifest, it is empty");
        }
        if (!(object instanceof Map)) {
            throw new SkipperException("Can't parse manifest, it is not a map.  Manifest = " + object);
        }
        Map manifestAsMap = (Map)object;
        Object kindObject = manifestAsMap.get("kind");
        if (kindObject instanceof String) {
            String kind = (String)kindObject;
            if (Arrays.asList(this.getSupportedKinds()).contains(kind)) {
                logger.debug("Found supported kind " + kind);
                return true;
            }
        }
        return false;
    }
}

