/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="proxy.auth")
public class ProxyAuthenticationProperties {
    private Map<String, Route> routes = new HashMap<String, Route>();
    private boolean loadBalanced;

    @PostConstruct
    public void init() {
        for (Map.Entry<String, Route> entry : this.routes.entrySet()) {
            if (entry.getValue().getId() != null) continue;
            entry.getValue().setId(entry.getKey());
        }
    }

    public Map<String, Route> getRoutes() {
        return this.routes;
    }

    public boolean isLoadBalanced() {
        return this.loadBalanced;
    }

    public void setLoadBalanced(boolean loadBalanced) {
        this.loadBalanced = loadBalanced;
    }

    public static class Route {
        private String id;
        private String scheme;

        public Route(String scheme) {
            this.scheme = scheme;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public static final class Scheme {
            public static final Scheme OAUTH2 = new Scheme("oauth2");
            public static final Scheme PASSTHRU = new Scheme("passthru");
            public static final Scheme NONE = new Scheme("none");
            private final String value;

            private Scheme(String value) {
                this.value = value;
            }

            public boolean matches(String value) {
                return value != null && value.equals(this.value);
            }
        }
    }
}

