/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.proxy;

import com.netflix.zuul.ZuulFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.security.oauth2.proxy.AuthenticationHeaderFilter;
import org.springframework.cloud.security.oauth2.proxy.OAuth2TokenRelayFilter;
import org.springframework.cloud.security.oauth2.proxy.ProxyAuthenticationProperties;
import org.springframework.cloud.security.oauth2.resource.ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;

@Configuration
@ConditionalOnClass(value={ZuulFilter.class, EnableOAuth2Client.class, SecurityProperties.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ProxyAuthenticationProperties.class})
public class OAuth2ProxyAutoConfiguration {
    @Autowired
    private ProxyAuthenticationProperties properties;
    @Autowired(required=false)
    private OAuth2RestTemplate restTemplate;
    @Autowired(required=false)
    @LoadBalanced
    private OAuth2RestTemplate loadBalancedRestTemplate;
    @Autowired
    private ResourceServerProperties resourceServerProperties;

    @Bean
    public OAuth2TokenRelayFilter oauth2TokenRelayFilter() {
        OAuth2TokenRelayFilter filter = new OAuth2TokenRelayFilter(this.properties);
        if (this.loadBalancedRestTemplate != null && this.resourceServerProperties.isLoadBalanced()) {
            filter.setRestTemplate((OAuth2RestOperations)this.loadBalancedRestTemplate);
        } else if (this.restTemplate != null) {
            filter.setRestTemplate((OAuth2RestOperations)this.restTemplate);
        }
        return filter;
    }

    @ConditionalOnClass(value={ProxyRequestHelper.class, TraceRepository.class})
    @Configuration
    protected static class AuthenticationHeaderFilterConfiguration {
        @Autowired(required=false)
        private TraceRepository traces;

        protected AuthenticationHeaderFilterConfiguration() {
        }

        @Bean
        public AuthenticationHeaderFilter authenticationHeaderFilter(ProxyAuthenticationProperties properties) {
            ProxyRequestHelper helper = new ProxyRequestHelper();
            if (this.traces != null) {
                helper.setTraces(this.traces);
            }
            return new AuthenticationHeaderFilter(helper, properties);
        }
    }
}

