/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.environment;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;

public class VcapServiceCredentialsListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Map properties = new RelaxedPropertyResolver((PropertyResolver)event.getEnvironment()).getSubProperties("vcap.services.");
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("spring.oauth.sso.logoutUri", "${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.logoutUri:}");
        source.put("spring.oauth2.resource.id", "${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.id:}");
        source.put("spring.oauth2.resource.userInfoUri", "${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.userInfoUri:${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.userInfoUri:}}");
        source.put("spring.oauth2.resource.tokenInfoUri", "${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.tokenInfoUri:${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.tokenInfoUri:}}");
        source.put("spring.oauth2.resource.jwt.keyUri", "${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.keyUri:${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.keyUri:}}");
        source.put("spring.oauth2.resource.jwt.keyValue", "${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.keyValue:${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.keyValue:}}");
        source.put("spring.oauth2.client.accessTokenUri", "${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.tokenUri:${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.tokenUri:}}");
        source.put("spring.oauth2.client.userAuthorizationUri", "${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.authorizationUri:${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.authorizationUri:}}");
        source.put("spring.oauth2.client.clientId", "${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.clientId:${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.clientId:}}");
        source.put("spring.oauth2.client.clientSecret", "${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.clientSecret:${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.clientSecret:}}");
        source.put("spring.oauth2.client.scope", "${vcap.services.${spring.oauth2.sso.serviceId:sso}.credentials.scope:${vcap.services.${spring.oauth2.resource.serviceId:resource}.credentials.scope:}}");
        event.getEnvironment().getPropertySources().addLast((PropertySource)new MapPropertySource("cloudDefaultSecurityBindings", source));
    }
}

