/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.scheduler.spi.kubernetes;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.scheduler.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.scheduler.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.scheduler.spi.kubernetes.RestartPolicy;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.cloud.scheduler.kubernetes")
public class KubernetesSchedulerProperties {
    public static final String KUBERNETES_SCHEDULER_PROPERTIES = "spring.cloud.scheduler.kubernetes";
    private static final String DEFAULT_KUBERNETES_NAMESPACE = "default";
    protected static final String ENV_KEY_KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String ENV_KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE");
    private static String KUBERNETES_NAMESPACE = StringUtils.hasText((String)ENV_KUBERNETES_NAMESPACE) ? ENV_KUBERNETES_NAMESPACE : "default";
    private ImagePullPolicy imagePullPolicy = ImagePullPolicy.IfNotPresent;
    private RestartPolicy restartPolicy = RestartPolicy.Never;
    private EntryPointStyle entryPointStyle = EntryPointStyle.exec;
    private String namespace = KUBERNETES_NAMESPACE;
    private String imagePullSecret;
    protected static final String DEFAULT_TASK_SERVICE_ACCOUNT_NAME = "default";
    private String taskServiceAccountName = "default";
    private String[] environmentVariables = new String[0];

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public EntryPointStyle getEntryPointStyle() {
        return this.entryPointStyle;
    }

    public void setEntryPointStyle(EntryPointStyle entryPointStyle) {
        this.entryPointStyle = entryPointStyle;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public void setImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
    }

    public String getTaskServiceAccountName() {
        return this.taskServiceAccountName;
    }

    public void setTaskServiceAccountName(String taskServiceAccountName) {
        this.taskServiceAccountName = taskServiceAccountName;
    }

    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(String[] environmentVariables) {
        this.environmentVariables = environmentVariables;
    }
}

