/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.ribbon.RibbonApplicationContextInitializer;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;

public class ZuulRouteApplicationContextInitializer
extends RibbonApplicationContextInitializer {
    public ZuulRouteApplicationContextInitializer(SpringClientFactory springClientFactory, ZuulProperties zuulProperties) {
        super(springClientFactory, ZuulRouteApplicationContextInitializer.getServiceIdsFromZuulProps(zuulProperties));
    }

    private static List<String> getServiceIdsFromZuulProps(ZuulProperties zuulProperties) {
        Map<String, ZuulProperties.ZuulRoute> zuulRoutes = zuulProperties.getRoutes();
        Collection<ZuulProperties.ZuulRoute> registeredRoutes = zuulRoutes.values();
        ArrayList<String> serviceIds = new ArrayList<String>();
        if (registeredRoutes != null) {
            for (ZuulProperties.ZuulRoute route : registeredRoutes) {
                String serviceId = route.getServiceId();
                if (serviceId == null) continue;
                serviceIds.add(serviceId);
            }
        }
        return serviceIds;
    }
}

