/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SendErrorFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SendErrorFilter.class);
    protected static final String SEND_ERROR_FILTER_RAN = "sendErrorFilter.ran";
    @Value(value="${error.path:/error}")
    private String errorPath;

    public String filterType() {
        return "error";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.getThrowable() != null && !ctx.getBoolean(SEND_ERROR_FILTER_RAN, false);
    }

    public Object run() {
        try {
            RequestDispatcher dispatcher;
            RequestContext ctx = RequestContext.getCurrentContext();
            ExceptionHolder exception = this.findZuulException(ctx.getThrowable());
            HttpServletRequest request = ctx.getRequest();
            request.setAttribute("javax.servlet.error.status_code", (Object)exception.getStatusCode());
            log.warn((Object)"Error during filtering", exception.getThrowable());
            request.setAttribute("javax.servlet.error.exception", (Object)exception.getThrowable());
            if (StringUtils.hasText((String)exception.getErrorCause())) {
                request.setAttribute("javax.servlet.error.message", (Object)exception.getErrorCause());
            }
            if ((dispatcher = request.getRequestDispatcher(this.errorPath)) != null) {
                ctx.set(SEND_ERROR_FILTER_RAN, (Object)true);
                if (!ctx.getResponse().isCommitted()) {
                    ctx.setResponseStatusCode(exception.getStatusCode());
                    dispatcher.forward((ServletRequest)request, (ServletResponse)ctx.getResponse());
                }
            }
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    protected ExceptionHolder findZuulException(Throwable throwable) {
        if (throwable.getCause() instanceof ZuulRuntimeException) {
            return new ZuulExceptionHolder((ZuulException)throwable.getCause().getCause());
        }
        if (throwable.getCause() instanceof ZuulException) {
            return new ZuulExceptionHolder((ZuulException)throwable.getCause());
        }
        if (throwable instanceof ZuulException) {
            return new ZuulExceptionHolder((ZuulException)throwable);
        }
        return new DefaultExceptionHolder(throwable);
    }

    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }

    protected static class ZuulExceptionHolder
    implements ExceptionHolder {
        private final ZuulException exception;

        public ZuulExceptionHolder(ZuulException exception) {
            this.exception = exception;
        }

        @Override
        public Throwable getThrowable() {
            return this.exception;
        }

        @Override
        public int getStatusCode() {
            return this.exception.nStatusCode;
        }

        @Override
        public String getErrorCause() {
            return this.exception.errorCause;
        }
    }

    protected static class DefaultExceptionHolder
    implements ExceptionHolder {
        private final Throwable throwable;

        public DefaultExceptionHolder(Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    protected static interface ExceptionHolder {
        public Throwable getThrowable();

        default public int getStatusCode() {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }

        default public String getErrorCause() {
            return null;
        }
    }
}

