/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.sidecar;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SidecarController {
    @Autowired
    private DiscoveryClient discovery;
    @Value(value="${spring.application.name}")
    private String appName;

    @RequestMapping(value={"/ping"})
    public String ping() {
        return "OK";
    }

    @RequestMapping(value={"/hosts/{appName}"})
    public List<ServiceInstance> hosts(@PathVariable(value="appName") String appName) {
        return this.hosts2(appName);
    }

    @RequestMapping(value={"/hosts"})
    public List<ServiceInstance> hosts2(@RequestParam(value="appName") String appName) {
        List instances = this.discovery.getInstances(appName);
        return instances;
    }

    @RequestMapping(value={"/"}, produces={"text/html"})
    public String home() {
        return "<head><title>Sidecar</title></head><body>\n<a href='/ping'>ping</a><br/>\n<a href='/actuator/health'>health</a><br/>\n<a href='/hosts/" + this.appName + "'>hosts/" + this.appName + "</a><br/>\n</body>";
    }
}

