/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;
import org.springframework.util.StringUtils;

public abstract class AbstractHystrixConfigBuilder<CONFB>
implements ConfigBuilder<CONFB> {
    private final String commandName;
    protected String groupName;
    protected HystrixCommandProperties.Setter commandProperties;

    public AbstractHystrixConfigBuilder(String id) {
        this.commandName = id;
    }

    public AbstractHystrixConfigBuilder groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public AbstractHystrixConfigBuilder commandProperties(HystrixCommandProperties.Setter commandProperties) {
        this.commandProperties = commandProperties;
        return this;
    }

    protected HystrixCommandGroupKey getGroupKey() {
        String groupNameToUse = StringUtils.hasText((String)this.groupName) ? this.groupName : this.commandName + "group";
        return HystrixCommandGroupKey.Factory.asKey((String)groupNameToUse);
    }

    protected HystrixCommandKey getCommandKey() {
        return HystrixCommandKey.Factory.asKey((String)this.commandName);
    }

    protected HystrixCommandProperties.Setter getCommandPropertiesSetter() {
        return this.commandProperties != null ? this.commandProperties : HystrixCommandProperties.Setter();
    }
}

