/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.Jersey3DiscoveryClientOptionalArgs;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey3.Jersey3TransportClientFactories;
import com.netflix.eureka.transport.EurekaServerHttpClientFactory;
import com.netflix.eureka.transport.Jersey3EurekaServerHttpClientFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.configuration.SSLContextFactory;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.server.EurekaServerMarkerConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={EurekaServerMarkerConfiguration.Marker.class})
public class EurekaServerJerseyClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class})
    public Jersey3DiscoveryClientOptionalArgs jersey3DiscoveryClientOptionalArgs(@Autowired(required=false) TlsProperties tlsProperties) throws GeneralSecurityException, IOException {
        Jersey3DiscoveryClientOptionalArgs optionalArgs = new Jersey3DiscoveryClientOptionalArgs();
        if (tlsProperties != null && tlsProperties.isEnabled()) {
            SSLContextFactory factory = new SSLContextFactory(tlsProperties);
            optionalArgs.setSSLContext(factory.createSSLContext());
        }
        return optionalArgs;
    }

    @Bean
    @ConditionalOnMissingBean(value={TransportClientFactories.class})
    public Jersey3TransportClientFactories jersey3TransportClientFactories() {
        return Jersey3TransportClientFactories.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaServerHttpClientFactory.class})
    public Jersey3EurekaServerHttpClientFactory jersey3EurekaServerHttpClientFactory() {
        return new Jersey3EurekaServerHttpClientFactory();
    }
}

