/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaHttpClientUtils;
import org.springframework.cloud.netflix.eureka.http.NotFoundHttpResponse;
import org.springframework.cloud.netflix.eureka.http.RestClientEurekaHttpClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

public class RestClientTransportClientFactory
implements TransportClientFactory {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostnameVerifier> hostnameVerifier;
    private final EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier;
    private final Supplier<RestClient.Builder> builderSupplier;

    public RestClientTransportClientFactory(Optional<SSLContext> sslContext, Optional<HostnameVerifier> hostnameVerifier, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, Supplier<RestClient.Builder> builderSupplier) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.eurekaClientHttpRequestFactorySupplier = eurekaClientHttpRequestFactorySupplier;
        this.builderSupplier = builderSupplier;
    }

    public RestClientTransportClientFactory(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, Supplier<RestClient.Builder> builderSupplier) {
        this(EurekaHttpClientUtils.context(tlsProperties), Optional.empty(), eurekaClientHttpRequestFactorySupplier, builderSupplier);
    }

    public RestClientTransportClientFactory(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier) {
        this(tlsProperties, eurekaClientHttpRequestFactorySupplier, RestClient::builder);
    }

    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        RestClient.Builder builder = this.builderSupplier.get().clone();
        ClientHttpRequestFactory requestFactory = this.eurekaClientHttpRequestFactorySupplier.get(this.sslContext.orElse(null), this.hostnameVerifier.orElse(null));
        builder.requestFactory(requestFactory);
        RestClientTransportClientFactory.setUrl(builder, endpoint.getServiceUrl());
        builder.messageConverters(converters -> converters.add(0, EurekaHttpClientUtils.mappingJacksonHttpMessageConverter()));
        builder.defaultStatusHandler(HttpStatusCode::isError, (req, res) -> {});
        builder.requestInterceptor((request, body, execution) -> {
            ClientHttpResponse response = execution.execute(request, body);
            if (!response.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                return response;
            }
            return new NotFoundHttpResponse(response);
        });
        return new RestClientEurekaHttpClient(builder.build());
    }

    public void shutdown() {
    }

    private static void setUrl(RestClient.Builder builder, String serviceUrl) {
        String url = UriComponentsBuilder.fromUriString((String)serviceUrl).userInfo(null).toUriString();
        EurekaHttpClientUtils.UserInfo userInfo = EurekaHttpClientUtils.extractUserInfo(serviceUrl);
        if (userInfo != null) {
            builder.requestInterceptor((ClientHttpRequestInterceptor)new BasicAuthenticationInterceptor(userInfo.username(), userInfo.password()));
        }
        builder.baseUrl(url);
    }
}

