/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceInfoFactory {
    private static final Log log = LogFactory.getLog(InstanceInfoFactory.class);

    public InstanceInfo create(EurekaInstanceConfig config) {
        LeaseInfo.Builder leaseInfoBuilder = LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(config.getLeaseRenewalIntervalInSeconds()).setDurationInSecs(config.getLeaseExpirationDurationInSeconds());
        InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
        Object namespace = config.getNamespace();
        if (!((String)namespace).endsWith(".")) {
            namespace = (String)namespace + ".";
        }
        builder.setNamespace((String)namespace).setAppName(config.getAppname()).setInstanceId(config.getInstanceId()).setAppGroupName(config.getAppGroupName()).setDataCenterInfo(config.getDataCenterInfo()).setIPAddr(config.getIpAddress()).setHostName(config.getHostName(false)).setPort(config.getNonSecurePort()).enablePort(InstanceInfo.PortType.UNSECURE, config.isNonSecurePortEnabled()).setSecurePort(config.getSecurePort()).enablePort(InstanceInfo.PortType.SECURE, config.getSecurePortEnabled()).setVIPAddress(config.getVirtualHostName()).setSecureVIPAddress(config.getSecureVirtualHostName()).setHomePageUrl(config.getHomePageUrlPath(), config.getHomePageUrl()).setStatusPageUrl(config.getStatusPageUrlPath(), config.getStatusPageUrl()).setHealthCheckUrls(config.getHealthCheckUrlPath(), config.getHealthCheckUrl(), config.getSecureHealthCheckUrl()).setASGName(config.getASGName());
        if (!config.isInstanceEnabledOnit()) {
            InstanceInfo.InstanceStatus initialStatus = InstanceInfo.InstanceStatus.STARTING;
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting initial instance status as: " + String.valueOf(initialStatus)));
            }
            builder.setStatus(initialStatus);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Setting initial instance status as: " + String.valueOf(InstanceInfo.InstanceStatus.UP) + ". This may be too early for the instance to advertise itself as available. You would instead want to control this via a healthcheck handler."));
        }
        for (Map.Entry entry : config.getMetadataMap().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || value.isEmpty()) continue;
            builder.add(key, value);
        }
        InstanceInfo instanceInfo = builder.build();
        instanceInfo.setLeaseInfo(leaseInfoBuilder.build());
        return instanceInfo;
    }
}

