/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import java.util.function.Supplier;
import org.springframework.cloud.netflix.eureka.http.EurekaHttpClientUtils;
import org.springframework.cloud.netflix.eureka.http.WebClientEurekaHttpClient;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebClientTransportClientFactory
implements TransportClientFactory {
    private final Supplier<WebClient.Builder> builderSupplier;

    public WebClientTransportClientFactory(Supplier<WebClient.Builder> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        WebClient.Builder builder = this.builderSupplier.get().clone();
        this.setUrl(builder, endpoint.getServiceUrl());
        this.setCodecs(builder);
        builder.filter(this.http4XxErrorExchangeFilterFunction());
        return new WebClientEurekaHttpClient(builder.build());
    }

    private WebClient.Builder setUrl(WebClient.Builder builder, String serviceUrl) {
        String url = UriComponentsBuilder.fromUriString((String)serviceUrl).userInfo(null).toUriString();
        EurekaHttpClientUtils.UserInfo userInfo = EurekaHttpClientUtils.extractUserInfo(serviceUrl);
        if (userInfo != null) {
            builder.filter(ExchangeFilterFunctions.basicAuthentication((String)userInfo.username(), (String)userInfo.password()));
        }
        return builder.baseUrl(url);
    }

    private void setCodecs(WebClient.Builder builder) {
        ObjectMapper objectMapper = EurekaHttpClientUtils.objectMapper();
        builder.codecs(configurer -> {
            ClientCodecConfigurer.ClientDefaultCodecs defaults = configurer.defaultCodecs();
            defaults.jacksonJsonDecoder((Decoder)new Jackson2JsonDecoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
            defaults.jacksonJsonEncoder((Encoder)new Jackson2JsonEncoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
            defaults.jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
            defaults.jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
        });
    }

    private ExchangeFilterFunction http4XxErrorExchangeFilterFunction() {
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            if (clientResponse.statusCode().value() == 400) {
                ClientResponse newResponse = clientResponse.mutate().statusCode((HttpStatusCode)HttpStatus.OK).build();
                newResponse.body((clientHttpResponse, context) -> clientHttpResponse.getBody());
                return Mono.just((Object)newResponse);
            }
            if (clientResponse.statusCode().equals(HttpStatus.NOT_FOUND)) {
                ClientResponse newResponse = clientResponse.mutate().statusCode(clientResponse.statusCode()).body(Flux.empty()).build();
                return Mono.just((Object)newResponse);
            }
            return Mono.just((Object)clientResponse);
        });
    }

    public void shutdown() {
    }
}

