/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.config.EurekaConfigServerInstanceProvider;
import org.springframework.cloud.netflix.eureka.config.HostnameBasedUrlRandomizer;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactory;
import org.springframework.util.ClassUtils;

public class EurekaConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null)) {
            return;
        }
        registry.registerIfAbsent(EurekaClientConfigBean.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.getDiscoveryEnabled(binder).booleanValue()) {
                return null;
            }
            return (EurekaClientConfigBean)binder.bind("eureka.client", EurekaClientConfigBean.class).orElseGet(EurekaClientConfigBean::new);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.getDiscoveryEnabled(binder).booleanValue()) {
                return null;
            }
            EurekaClientConfigBean config = (EurekaClientConfigBean)context.get(EurekaClientConfigBean.class);
            EurekaHttpClient httpClient = new RestTemplateTransportClientFactory((TlsProperties)context.getOrElse(TlsProperties.class, null), (EurekaClientHttpRequestFactorySupplier)context.getOrElse(EurekaClientHttpRequestFactorySupplier.class, (Object)new DefaultEurekaClientHttpRequestFactorySupplier())).newClient((EurekaEndpoint)HostnameBasedUrlRandomizer.randomEndpoint(config, binder));
            return new EurekaConfigServerInstanceProvider(httpClient, config)::getInstances;
        });
    }

    private Boolean getDiscoveryEnabled(Binder binder) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Boolean.class).orElse((Object)false);
    }
}

