/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.netflix.eureka.MutableDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestTemplateDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.WebClientDiscoveryClientOptionalArgs;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
public class DiscoveryClientOptionalArgsConfiguration {
    protected static final Log logger = LogFactory.getLog(DiscoveryClientOptionalArgsConfiguration.class);

    @Bean
    @ConditionalOnMissingClass(value={"com.sun.jersey.api.client.filter.ClientFilter"})
    @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, matchIfMissing=true, havingValue="false")
    public RestTemplateDiscoveryClientOptionalArgs restTemplateDiscoveryClientOptionalArgs() {
        logger.info((Object)"Eureka HTTP Client uses RestTemplate.");
        return new RestTemplateDiscoveryClientOptionalArgs();
    }

    @Bean
    @ConditionalOnClass(name={"com.sun.jersey.api.client.filter.ClientFilter"})
    @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
    public MutableDiscoveryClientOptionalArgs discoveryClientOptionalArgs() {
        return new MutableDiscoveryClientOptionalArgs();
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.sun.jersey.api.client.filter.ClientFilter", "org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    protected static class WebClientNotFoundConfiguration {
        public WebClientNotFoundConfiguration() {
            throw new IllegalStateException("eureka.client.webclient.enabled is true, but WebClient is not on the classpath. Please add spring-boot-starter-webflux as a dependency.");
        }
    }

    @ConditionalOnMissingClass(value={"com.sun.jersey.api.client.filter.ClientFilter"})
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    protected static class WebClientConfiguration {
        protected WebClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractDiscoveryClientOptionalArgs.class, RestTemplateDiscoveryClientOptionalArgs.class}, search=SearchStrategy.CURRENT)
        public WebClientDiscoveryClientOptionalArgs webClientDiscoveryClientOptionalArgs(ObjectProvider<WebClient.Builder> builder) {
            logger.info((Object)"Eureka HTTP Client uses WebClient.");
            return new WebClientDiscoveryClientOptionalArgs(() -> builder.getIfAvailable());
        }
    }
}

