/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class SubsetServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private final String instanceId;
    private final int size;

    public SubsetServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, PropertyResolver resolver, ReactiveLoadBalancer.Factory<ServiceInstance> factory) {
        super(delegate);
        LoadBalancerProperties properties = factory.getProperties(this.getServiceId());
        if (properties == null) {
            properties = new LoadBalancerProperties();
        }
        this.instanceId = SubsetServiceInstanceListSupplier.resolveInstanceId(properties, resolver);
        this.size = properties.getSubset().getSize();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return this.get(new Request(){

            public @Nullable Object getContext() {
                return super.getContext();
            }
        });
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        return this.delegate.get(request).map(instances -> {
            if (instances.size() <= this.size) {
                return instances;
            }
            instances = new ArrayList(instances);
            int instanceId = this.instanceId.hashCode() & Integer.MAX_VALUE;
            int count = instances.size() / this.size;
            int round = instanceId / count;
            Random random = new Random(round);
            Collections.shuffle(instances, random);
            int bucket = instanceId % count;
            int start = bucket * this.size;
            return instances.subList(start, start + this.size);
        });
    }

    private static String resolveInstanceId(LoadBalancerProperties properties, PropertyResolver resolver) {
        String instanceId = properties.getSubset().getInstanceId();
        if (StringUtils.hasText((String)instanceId)) {
            return resolver.resolvePlaceholders(properties.getSubset().getInstanceId());
        }
        return IdUtils.getDefaultInstanceId((PropertyResolver)resolver);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getSize() {
        return this.size;
    }
}

