/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.EmptyServerHttpResponse;
import org.springframework.cloud.loadbalancer.core.LoadBalancerServerHttpRequest;
import org.springframework.cloud.loadbalancer.core.ReactiveLoadBalancerApiVersionStrategy;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.support.DefaultServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.reactive.accept.MediaTypeParamApiVersionResolver;
import org.springframework.web.reactive.accept.PathApiVersionResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import org.springframework.web.server.i18n.AcceptHeaderLocaleContextResolver;
import org.springframework.web.server.i18n.LocaleContextResolver;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Flux;

public class ReactiveApiVersionServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    public static final String API_VERSION = "API_VERSION";
    private static final Log LOG = LogFactory.getLog(ReactiveApiVersionServiceInstanceListSupplier.class);
    private final boolean callGetWithRequestOnDelegates;
    private final LoadBalancerProperties.ApiVersion apiVersionProperties;
    private final LoadBalancerClientFactory loadBalancerClientFactory;
    private @Nullable ApiVersionParser<?> apiVersionParser;
    private @Nullable ApiVersionStrategy apiVersionStrategy;

    public ReactiveApiVersionServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerClientFactory loadBalancerClientFactory) {
        super(delegate);
        String serviceId = this.getServiceId();
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        LoadBalancerProperties properties = loadBalancerClientFactory.getProperties(serviceId);
        if (properties != null) {
            this.callGetWithRequestOnDelegates = properties.isCallGetWithRequestOnDelegates();
            this.apiVersionProperties = properties.getApiVersion();
        } else {
            this.callGetWithRequestOnDelegates = true;
            this.apiVersionProperties = new LoadBalancerProperties.ApiVersion();
        }
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        Object requestContext = request.getContext();
        if (this.callGetWithRequestOnDelegates && requestContext instanceof RequestDataContext) {
            RequestDataContext requestDataContext = (RequestDataContext)requestContext;
            return this.getDelegate().get(request).map(serviceInstances -> this.filteredByVersion((List<ServiceInstance>)serviceInstances, this.getVersionFromRequest(requestDataContext.getClientRequest())));
        }
        return this.get();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        Comparable defaultVersion = this.getApiVersionStrategy().getDefaultVersion();
        return ((Flux)this.getDelegate().get()).map(serviceInstances -> this.filteredByVersion((List<ServiceInstance>)serviceInstances, defaultVersion));
    }

    private List<ServiceInstance> filteredByVersion(List<ServiceInstance> serviceInstances, @Nullable Comparable<?> requestedVersion) {
        List<ServiceInstance> filteredInstances;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Matching instances by API Version: " + String.valueOf(requestedVersion)));
        }
        if (requestedVersion != null && !(filteredInstances = serviceInstances.parallelStream().filter(instance -> requestedVersion.equals(this.getVersion((ServiceInstance)instance))).toList()).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found matching instances by API Version: " + String.valueOf(filteredInstances)));
            }
            return filteredInstances;
        }
        if (this.apiVersionProperties.isFallbackToAvailableInstances()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No matching instances found by API Version: " + String.valueOf(requestedVersion) + ". Falling back to all available instances."));
            }
            return serviceInstances;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No matching instances found by API Version: " + String.valueOf(requestedVersion) + ". Returning empty list."));
        }
        return List.of();
    }

    void setApiVersionParser(ApiVersionParser<?> apiVersionParser) {
        this.apiVersionParser = apiVersionParser;
    }

    private @Nullable Comparable<?> getVersionFromRequest(@Nullable RequestData requestData) {
        if (requestData == null) {
            return null;
        }
        ServerWebExchange exchange = ReactiveApiVersionServiceInstanceListSupplier.buildServerWebExchange(requestData);
        Comparable apiVersion = this.getApiVersionStrategy().resolveParseAndValidateVersion(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved Api Version from request: " + String.valueOf(apiVersion)));
        }
        return apiVersion;
    }

    private @Nullable Comparable<?> getVersion(ServiceInstance serviceInstance) {
        String version;
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null && (version = (String)metadata.get(API_VERSION)) != null) {
            return this.getApiVersionStrategy().parseVersion(version);
        }
        return null;
    }

    private static ServerWebExchange buildServerWebExchange(RequestData requestData) {
        LoadBalancerServerHttpRequest serverRequest = new LoadBalancerServerHttpRequest(requestData);
        EmptyServerHttpResponse serverResponse = new EmptyServerHttpResponse();
        return new DefaultServerWebExchange((ServerHttpRequest)serverRequest, (ServerHttpResponse)serverResponse, (WebSessionManager)new DefaultWebSessionManager(), (ServerCodecConfigurer)new DefaultServerCodecConfigurer(), (LocaleContextResolver)new AcceptHeaderLocaleContextResolver());
    }

    private @Nullable ApiVersionParser getApiVersionParser() {
        if (this.apiVersionParser == null) {
            this.apiVersionParser = (ApiVersionParser)this.loadBalancerClientFactory.getInstance(this.getServiceId(), ApiVersionParser.class);
        }
        return this.apiVersionParser;
    }

    private ApiVersionStrategy getApiVersionStrategy() {
        if (this.apiVersionStrategy == null) {
            ApiVersionStrategy userProvidedApiVersionStrategy = (ApiVersionStrategy)this.loadBalancerClientFactory.getInstance(this.getServiceId(), ApiVersionStrategy.class);
            this.apiVersionStrategy = userProvidedApiVersionStrategy != null ? userProvidedApiVersionStrategy : this.buildApiVersionStrategy();
        }
        return this.apiVersionStrategy;
    }

    private ApiVersionStrategy buildApiVersionStrategy() {
        ArrayList<ApiVersionResolver> versionResolvers = new ArrayList<ApiVersionResolver>();
        if (StringUtils.hasText((String)this.apiVersionProperties.getHeader())) {
            versionResolvers.add(exchange -> exchange.getRequest().getHeaders().getFirst(this.apiVersionProperties.getHeader()));
        }
        if (StringUtils.hasText((String)this.apiVersionProperties.getQueryParameter())) {
            versionResolvers.add(exchange -> (String)exchange.getRequest().getQueryParams().getFirst((Object)this.apiVersionProperties.getQueryParameter()));
        }
        if (this.apiVersionProperties.getPathSegment() != null) {
            versionResolvers.add((ApiVersionResolver)new PathApiVersionResolver(this.apiVersionProperties.getPathSegment().intValue()));
        }
        this.apiVersionProperties.getMediaTypeParameters().forEach((mediaType, paramName) -> versionResolvers.add((ApiVersionResolver)new MediaTypeParamApiVersionResolver(mediaType, paramName)));
        return new ReactiveLoadBalancerApiVersionStrategy(versionResolvers, this.getApiVersionParser(), this.apiVersionProperties.getRequired(), this.apiVersionProperties.getDefaultVersion(), false, null, null);
    }
}

